/*
** ~ppr/src/libppr/icmp.c
** Copyright 1995, 1996, Trinity College Computing Center.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This file was last modified 15 February 1996.
*/

#include <stdio.h>
#include <ctype.h>

/*
** Perform a case insensitive comparison.
** If the strings differ, return non-zero.
*/
int icmp(const char *s1, const char *s2)
    {
    while( (toupper(*s1) == toupper(*s2)) )
        {
        if( (*s1==(char)NULL) && (*s2==(char)NULL) )
            return 0;
        else
            { s1++; s2++; }
        }
    return -1;
    } /* end of icmp() */

/*
** Perform a case insensitive comparison for up to n characters.
** If the strings differ, return non-zero.
*/
int icmpn(const char *s1, const char *s2, int n)
    {
    while( --n && (toupper(*(s1++)) == toupper(*(s2++))) );
    return n;    
    } /* end of icmpn() */

/* end of file */
