/*
** ~ppr/src/libppr/getdouble.c
** Copyright 1995, 1996, Trinity College Computing Center.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
** 
** Read text and return a double precision floating point number.
**
** We must use this because sscanf() does not recognize "1" or "42" as
** valid floating point numbers.
**
** Last modified 14 February 1996.
*/

#include <ctype.h>

double getdouble(const char *s)
    {
    double sign=1;
    double t=0;
    double place=0.1;

    while(*s==' ' || *s=='\t')      /* eat leading space */
        s++;

    if( *s == '+' )                 /* ignore plus sign */
        {
        s++;
        }
    else if( *s == '-' )            /* if minus sign, reverse sign */
        {
        sign=-1;
        s++;
        }

    while( isdigit(*s) )            /* read whole part */
        t=t*10.0 + (*(s++) - '0');

    if( *s == '.' )                 /* if decimal part */
        {
        s++;                        /* skip decimal point */

        while( isdigit(*s) )                /* read fractional part */
            {
            t+=( place * (*(s++) - '0') );
            place/=10;
            }
        } 

    return t * sign;
    } /* end of getdouble() */

/* end of file */

