/*
** ~ppr/src/libppr/foptions.c
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
**
** Last modified 22 February 1996.
*/

#include "global_defines.h"
#include <stdarg.h>
#include <string.h>

/* 
** When a filter option error is detected, this routine is used
** to, print up to 70 characters of the
** error in context with a caret underneath to show exactly
** where the error is.  Then print the error message under that.
**
** We adopt some elaborate methods because a filter options 
** string will very often exceed the terminal line width.
** We print the segement which options_get_one() has 
** indicated by setting options_error_context_index.  If that
** index is not zero we print "... " first.  If the part of 
** the string after the point indicated by the index is longer than
** 70 characters we print just the first 70 and append " ...".
**
** This uses the following global variables:
**
** options_string			the string with the error
** options_error_context_index		start of the word before the error 
** options_error_index			the point at which the error was detected
*/
void filter_option_error(int exit_code, const char *format, ...)
    {
    int caret_indent;
    va_list va;
	
    fputs("\nError in filter options:\n",stderr);

    /* print a segment of the eronious filter options string */
    fprintf(stderr,"%s%.70s%s\n",
		options_error_context_index > 0 ? "... " : "",
        	&options_string[options_error_context_index],
        	(strlen(&options_string[options_error_context_index]) > 70 ? " ..." : "") );

    /* print the caret under it at the right place */
    caret_indent = 0;
    if(options_error_context_index > 0) caret_indent += 4;
    caret_indent += (options_error_index - options_error_context_index);
    while(caret_indent--)
	fputc(' ',stderr);
    fputs("^\n",stderr);
        
    /* print the error message */
    va_start(va,format);
    vfprintf(stderr,format,va);
    va_end(va);
    
    fputs("\n\n",stderr);

    /* Exit, using the code we were told to. */
    exit(exit_code);
    } /* end of filter_error() */
        
/* end of file */
