/*
** ~ppr/src/libppr/findres.c
** Copyright 1995, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** The purpose of the functions in this module is to search for PostScript
** resources in the resource cache.  This cache has two parts.  The first 
** one is the "permanent cache".  This is located in /usr/ppr/cache.  Files
** must be deliverately placed in the cache.  The second is the "automatic
** cache".  Files are placed in this cache automatically when they are found
** in incoming print jobs.
**
** This file was last modified 21 December 1995.
*/

#include "global_defines.h"
#include <sys/stat.h>

/*
** Return a pointer to the filename of a resource in the cache.
**
** If we substitute a newer revision, we will store the new revision
** number in the integer pointed to by "newrev".
*/
char *noalloc_find_cached_resource(const char *res_type, const char *res_name,
		double version, int revision, int *newrev, mode_t *mode)
    {
    static char fname1[MAX_PATH];
    static char fname2[MAX_PATH];
    struct stat statbuf;
    
    /* Generate the resource file name as it would exist in both the */
    /* permanent and automatic caches. */
    if(strcmp(res_type,"procset")==0)
    	{
    	sprintf(fname1,PRE_CACHEDIR"/procset/%s-%s-%d",res_name,dtostr(version),revision);
    	sprintf(fname2,CACHEDIR"/procset/%s-%s-%d",res_name,dtostr(version),revision);
    	}
    else
    	{
    	sprintf(fname1,PRE_CACHEDIR"/%s/%s",res_type,res_name);
    	sprintf(fname2,CACHEDIR"/%s/%s",res_type,res_name);
    	}
    	
    /* Try the permanent cache. */
    if( stat(fname1,&statbuf) == 0 )
	{
    	if( mode != (mode_t*)NULL )
    	    *mode = statbuf.st_mode;
    	return fname1;
    	}
    	
    /* Try the automatic cache. */
    if( stat(fname2,&statbuf) == 0 )
    	{
    	if( mode != (mode_t*)NULL )
    	    *mode = statbuf.st_mode;
    	return fname2;
    	}
    	
    /* Looks like it is not in either cache. */
    return (char*)NULL;
    } /* end of noalloc_find_cached_resource() */

/*
** In this version, if the pointer is not NULL, it points
** into newly allocated memory.
*/
char *find_cached_resource(const char *res_type, const char *res_name,
		double version, int revision, int *newrev, mode_t *mode)
    {
    char *ptr;
    
    if( (ptr=noalloc_find_cached_resource(res_type,res_name,version,revision,newrev,mode)) != (char*)NULL )
    	return mystrdup(ptr);
    else
    	return (char*)NULL;
    } /* end of find_cached_resource() */
    
/* end of file */
