/*
** ~ppr/src/libppr/destspec.c
** Copyright 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This file was last modified 23 October 1996.
*/

#include "global_defines.h"

/*
** If the destination system is not this system, return "$destnode:$destname",
** if it is this system, return just "$destname".
*/
const char *network_destspec(const char *destnode, const char *destname)
    {
    static char return_str[MAX_NODENAME+MAX_DESTNAME+1];

    if( destname == (char*)NULL )
    	{
    	return "???";
    	}
    else if( destnode != (char*)NULL && strcmp(destnode, ppr_get_nodename()) )
	{
    	sprintf(return_str, "%s:%s", destnode, destname); 
	return return_str;
	}
    else
    	{
    	return destname;
    	}
    } /* end of local_jobid() */
    
/* end of file */
