/*
** ~ppr/src/libppr/daemon.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 6 January 1997.
*/

/*
** Library function to fork, leaving one copy in the background.
*/

#include "global_defines.h"
#include <signal.h>
#include <unistd.h>
#include <limits.h>

void daemon()
    {
    #ifndef NO_FORK		/* if we can't fork(), we can't do this */
    pid_t pid;

    signal(SIGHUP, SIG_IGN);	/* ignore group leader death */

    if( (pid=fork()) == -1 )    /* and split into two processes */
        {
        fputs("FATAL:  can't fork daemon\n", stderr);
        fatal(1, "can't fork daemon");
        }

    if(pid)		/* parent */
        _exit(0);	/* terminates now */
    else		/* child goes on to glory */
        {
        int fd;

	if(setsid() == -1)
            {
            fputs("FATAL: can't set session id\n", stderr);
            fatal(1, "can't set session id");
            }

        for(fd=0; fd < OPEN_MAX; fd++)	/* close all files */
            close(fd);              

        chdir(HOMEDIR);			/* don't prevent filesys umounts */
        }
    #endif
    } /* end of daemon() */

/* end of file */     

