#!/bin/sh
#
# ~ppr/src/interfaces/simple.sh
# Copyright 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 5 March 1997.
#

#
# This is a very simple interface which copies the file to a 
# port such as a parallel port.  Since most parallel ports
# are unidirecitonal, this interface does not attempt to receive
# PostScript error messages.
#

PRINTER="$1"
ADDRESS="$2"
OPTIONS="$3"
QUEUENAME="$4"
ROUTING="$5"

# read in the exit codes
. lib/interface.sh

# make sure the port can be written to
if [ ! -w "$ADDRESS" ]
	then
	if [ -c "$ADDRESS" ]
		then
		lib/alert $PRINTER TRUE "No permission to open port \"$ADDRESS\"."
		else
		lib/alert $PRINTER TRUE "Port \"$ADDRESS\" does not exist."
		fi
	exit $EXIT_PRNERR_NORETRY
	fi

# change standard output to the port
exec >$ADDRESS

# if we are terminated, write a control-d and exit
trap 'echo "\04"; exit $EXIT_SIGNAL' 15

# copy the job
/bin/cat -

# see if there was an error
errno=$?
if [ $errno -ne 0 ]
	then
	lib/alert $PRINTER TRUE "parallel interface: cat terminated with exit code $errno"
	exit $EXIT_PRNERR
	fi

exit $EXIT_PRINTED
