#!/bin/sh
#
# ~ppr/src/interfaces/gstcpip.sh
# Copyrigth 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 12 March 1997.
#

#
# This interface script passes the file through GhostScript.
# The GhostScript output file is sent to the printer using the
# normal tcpip interface.
#

# These will be filled in when the script is installed:
HOMEDIR="?"
SIGUSR1=?
SIGUSR2=?

# Where is GhostScript?
GS=/usr/bin/gs

# give the parameters names
PRINTER="$1"		# name of printer
ADDRESS="$2"		# address (file to write GhostScript output to)
OPTIONS="$3"		# options (GhostScript device name)
JOBNAME="$4"		# name of the job
ROUTING="$5"		# routing instructions
JOBBREAK="$6"
FEEDBACK="$7"
FOR="$8"		# user for whom it is being printed

# source interface.sh so we will know the correct exit codes
. lib/interface.sh

# Parse the options.  Save unknown options for
# the tcpip interface.
DEVICE=""
RESOLUTION=""
PPR_GS_INTERFACE_HACK_OPTIONS="patron=$$"
GSOPTS=""
for opt in $OPTIONS
    do
    case $opt in
	device=* )
	    DEVICE=`echo $opt | cut -d'=' -f2`
	    ;;	
	resolution=* )
	    RESOLUTION="-r`echo $opt | cut -d'=' -f2`"
	    ;;
	gs=* )
	    GS=`echo $opt | cut -d'=' -f2`
	    ;;
	gsopt=* )
	    GSOPTS="$GSOPTS `echo $opt | cut -d'=' -f2-`"
	    ;;
	* )
	    PPR_GS_INTERFACE_HACK_OPTIONS="$PPR_GS_INTERFACE_HACK_OPTIONS $opt"
	    ;;
    esac
    done

# make sure we have an option defined
if [ -z "$DEVICE" ]
	then
	lib/alert $PRINTER TRUE "Options must include \"device=\" to set the Ghostscript device name."
	exit $EXIT_PRNERR_NORETRY
	fi

# make sure we have GhostScript
if [ ! -x "$GS" ]
	then
	lib/alert $PRINTER TRUE "Path to GhostScript (\"$GS\") is incorrect."
	lib/alert $PRINTER FALSE "Use the gs= option to specify the correct path."
	exit $EXIT_PRNERR_NORETRY
	fi

# Set up patron signal handlers
trap 'exit $EXIT_PRNERR' $SIGUSR1
trap 'exit $EXIT_PRNERR_NORETRY' $SIGUSR2

# run ghostscript, file is stdin
export PPR_GS_INTERFACE_HACK_OPTIONS
$GS -q -sDEVICE=$DEVICE $RESOLUTION \
  -sFONTPATH=$HOMEDIR/cache/font -dSAFER \
  -sOutputFile="|interfaces/tcpip $PRINTER $ADDRESS x x x 0 0" $GSOPTS -

# if GhostScript failed, maybe it is a job error
retval=$?
case $retval in 
    0 )				# no error 
	exit $EXIT_PRINTED
	;;
    1 )				# many possibilities
	lib/alert $PRINTER TRUE "Possible Ghostscript invokation error.  Check options."
	# exit $EXIT_PRNERR_NORETRY
	exit $EXIT_JOBERR
	;;
    243 )			# PostScript error
	exit $EXIT_JOBERR
	;;
    * )
	lib/alert $PRINTER TRUE "GhostScript returned error level $retval."
	lib/alert $PRINTER FALSE "Try looking in the log for job \"$JOBNAME\"".
	exit $EXIT_PRNERR
esac

# end of file
