#!/bin/sh
#
# ~ppr/src/interfaces/gssimple.sh
# Copyright 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last revised 5 March 1997.
#

#
# This interface script passes the file through GhostScript.
# The GhostScript output file is directed to the port or file
# specified as the printer address.
#

# What is the PPR home directory?  This will be filled in when
# the script is installed.
HOMEDIR="?"

# Where is GhostScript?  This is a default value.
GS=/usr/bin/gs

# give the parameters names
PRINTER="$1"		# name of printer
ADDRESS="$2"		# address (file to write GhostScript output to)
OPTIONS="$3"		# options (GhostScript device name)
JOBNAME="$4"		# name of job
ROUTING="$5"		# routing instructions
JOBBREAK="$6"
FEEDBACK="$7"
FOR="$8"		# user for whom it is being printed

# source interface.sh so we will know the correct exit codes
. lib/interface.sh

# Parse the options
DEVICE="";
RESOLUTION="";
GSOPTS="";
for opt in $OPTIONS
    do
    case $opt in
	device=* )
	    DEVICE=`echo $opt | cut -d'=' -f2`
	    ;;	
	resolution=* )
	    RESOLUTION="-r`echo $opt | cut -d'=' -f2`"
	    ;;
	gs=* )
	    GS=`echo $opt | cut -d'=' -f2`
	    ;;
	gsopt=* )
	    GSOPTS="$GSOPTS `echo $opt | cut -d'=' -f2-`"
	    ;;
	* )
	    lib/alert $PRINTER TRUE "Unrecognized interface option: $opt"
	    exit $EXIT_PRNERR_NORETRY
	    ;;
    esac
    done

# make sure we have an option defined
if [ -z "$DEVICE" ]
	then
	lib/alert $PRINTER TRUE "Options must include \"device=\" to set the Ghostscript device name."
	exit $EXIT_PRNERR_NORETRY
	fi

# make sure the port can be written to
if [ ! -w "$ADDRESS" ]
	then
	if [ -c "$ADDRESS" ]
		then
		lib/alert $PRINTER TRUE "No permission to open port \"$ADDRESS\"."
		else
		lib/alert $PRINTER TRUE "Port \"$ADDRESS\" does not exist."
		fi
	exit $EXIT_PRNERR_NORETRY
	fi

# make sure we have GhostScript
if [ ! -x "$GS" ]
	then
	lib/alert $PRINTER TRUE "Path to GhostScript (\"$GS\") is incorrect."
	lib/alert $PRINTER FALSE "Use the gs= option to specify the correct path."
	exit $EXIT_PRNERR_NORETRY
	fi

# run ghostscript, file to be printed is on stdin
$GS -q -sDEVICE=$DEVICE $RESOLUTION -sFONTPATH=$HOMEDIR/cache/font \
	-dSAFER -sOutputFile=$ADDRESS $GSOPTS -

# if GhostScript failed, maybe it is a job error
retval=$?
case $retval in 
    0 )
	exit $EXIT_PRINTED
	;;
    243 )
	exit $EXIT_JOBERR
	;;
    1 )
	lib/alert $PRINTER TRUE "Possible Ghostscript invokation error.  Check options."
	# exit $EXIT_PRNERR_NORETRY
	exit $EXIT_JOBERR
	;;
    * )
	lib/alert $PRINTER TRUE "GhostScript returned error level $retval."
	exit $EXIT_PRNERR
	;;
esac

# end of file
