#!/bin/sh
#
# ~ppr/src/interfaces/dummy.sh
# Copyright 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 24 January 1997.
#

# 
# This is a test interface which just copies the input file to the
# output file designated by the printer's address parameter.
#

# source the file which defines the exit codes
. lib/interface.sh

# give the parameters names
PRINTER="$1"
ADDRESS="$2"
OPTIONS="$3"
QUEUENAME="$4"
ROUTING="$5"
JOBBREAK="$6"
FEEDBACK="$7"

SLEEP=""
for opt in $OPTIONS
    do
    case $opt in
	sleep=* )
	    SLEEP=`echo $opt | cut -d'=' -f2`
	    ;;	    
	* )
	    lib/alert $PRINTER TRUE "Unrecognized interface option: $opt"
	    exit $EXIT_PRNERR_NORETRY
	    ;;
    esac
    done

# make sure the address parameter is not empty
if [ -z "$ADDRESS" ]
	then
	lib/alert $PRINTER TRUE "Address is empty"
	exit $EXIT_PRNERR_NORETRY
	fi

# copy the file
cat - >$ADDRESS
if [ $? -ne 0 ]
	then
	lib/alert $PRINTER TRUE "cat failed"
	exit $EXIT_PRNERR_NORETRY
	fi

# Sleep if we have been asked to do so
if [ -n "$SLEEP" ]
	then
	sleep $SLEEP
	fi

# exit without error
exit $EXIT_OK
