/*
** ~ppr/src/interfaces/alert.c
** Copyright 1995, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This small program can be used by shell script printer interfaces
** which can't ordinarily call alert().
**
** This file was last modified 24 January 1995.
*/

#include "global_defines.h"
#include <unistd.h>
#include "util_exits.h"

int main(int argc, char *argv[])
	{
	int stamp;
	
	chdir(HOMEDIR);

	if(argc!=4)
		{
		fprintf(stderr,"%s: wrong number of parameters\n",argv[0]);
		exit(EXIT_SYNTAX);
		}

	if( (stamp=torf(argv[2])) == ANSWER_UNKNOWN )
		{
		fprintf(stderr,"%s: second parameter must be TRUE or FALSE\n",argv[0]);
		exit(EXIT_SYNTAX);
		}

	/* Call the library alert function to post the alert. */
	alert(argv[1],stamp,argv[3]);

	/* We assume it worked, exit. */
	exit(EXIT_OK);	
	} /* end of main() */
	
/* end of file */
