#!/bin/sh
#
# ~ppr/src/installprogs/setup_filters.sh
# Copyright 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 3 April 1997.
#

#
# This program is used to search the current path for programs which
# are suitable for use as input filters and create filter scripts
# which use them.
#

# PPR home directory.
HOMEDIR="?"

# PPR configuration directory.
CONFDIR="?"

# PPR spooling directory
VAR_SPOOL_PPR="?"

# PPR temporary files directory.
TEMPDIR="?"

# User and group names:
USER_PPR="?"
GROUP_PPOP="?"

# Function to find a program
findprog ()
    {
    echo "Searching for $1" >&2
    for i in `echo $PATH | tr ':' ' '`
	do
	if [ `echo $i | cut -c1` = '/' ]
	    then
	    # echo "Trying $i/$1" >&2
	    if [ -x "$i/$1" ]
		then
		$EECHO "\tFound $i/$1" >&2
		echo "$i/$1"
		return
		fi
	    fi
	done
    $EECHO "\tNot found" >&2
    }

# Run a shell script thru Sed, changing the program paths
sedit ()
    {
    sed -e "s#^\\(\$*\\)TROFF=\"[^\"]*\"#\\1TROFF=\"$TROFF\"#" \
	-e "s#^\\(\$*\\)EQN=\"[^\"]*\"#\\1EQN=\"$EQN\"#" \
	-e "s#^\\(\$*\\)REFER=\"[^\"]*\"#\\1REFER=\"$REFER\"#" \
	-e "s#^\\(\$*\\)TBL=\"[^\"]*\"#\\1TBL=\"$TBL\"#" \
	-e "s#^\\(\$*\\)PIC=\"[^\"]*\"#\\1PIC=\"$PIC\"#" \
	-e "s#^\\(\$*\\)GROFF=\"[^\"]*\"#\\1GROFF=\"$GROFF\"#" \
	-e "s#^\\(\$*\\)GROPS=\"[^\"]*\"#\\1GFOPS=\"$GROPS\"#" \
	-e "s#^\\(\$*\\)TEX=\"[^\"]*\"#\\1TEX=\"$TEX\"#" \
	-e "s#^\\(\$*\\)LATEX=\"[^\"]*\"#\\1LATEX=\"$LATEX\"#" \
	-e "s#^\\(\$*\\)TEXI2DVI=\"[^\"]*\"#\\1TEXI2DVI=\"$TEXI2DVI\"#" \
	-e "s#^\\(\$*\\)DVIPS=\"[^\"]*\"#\\1DVIPS=\"$DVIPS\"#" \
	-e "s#^\\(\$*\\)DJPEG=\"[^\"]*\"#\\1DJPEG=\"$DJPEG\"#" \
	-e "s#^\\(\$*\\)GIFTOPNM=\"[^\"]*\"#\\1GIFTOPNM=\"$GIFTOPNM\"#" \
	-e "s#^\\(\$*\\)PPMTOPGM=\"[^\"]*\"#\\1PPMTOPGM=\"$PPMTOPGM\"#" \
	-e "s#^\\(\$*\\)PNMTOPS=\"[^\"]*\"#\\1PNMTOPS=\"$PNMTOPS\"#" \
	-e "s#^\\(\$*\\)BMPTOPPM=\"[^\"]*\"#\\1BMPTOPPM=\"$BMPTOPPM\"#" \
	-e "s#^\\(\$*\\)XBMTOPBM=\"[^\"]*\"#\\1XBMTOPBM=\"$XBMTOPBM\"#" \
	-e "s#^\\(\$*\\)XPMTOPPM=\"[^\"]*\"#\\1XPMTOPPM=\"$XPMTOPPM\"#" \
	-e "s#^\\(\$*\\)XWDTOPNM=\"[^\"]*\"#\\1XWDTOPNM=\"$XWDTOPNM\"#" \
	-e "s#^\\(\$*\\)PNMDEPTH=\"[^\"]*\"#\\1PNMDEPTH=\"$PNMDEPTH\"#" \
	-e "s#^\\(\$*\\)TIFFTOPNM=\"[^\"]*\"#\\1TIFFTOPNM=\"$TIFFTOPNM\"#" \
	-e "s#^\\(\$*\\)PLOT2PS=\"[^\"]*\"#\\1PLOT2PS=\"$PLOT2PS\"#" \
	-e "s#^\\(\$*\\)POSTPLOT=\"[^\"]*\"#\\1POSTPLOT=\"$POSTPLOT\"#" \
	-e "s#^\\(\$*\\)FIG2DEV=\"[^\"]*\"#\\1FIG2DEV=\"$FIG2DEV\"#" \
	-e "s#^\\(\$*\\)HOMEDIR=\"[^\"]*\"#\\1HOMEDIR=\"$HOMEDIR\"#" \
	-e "s#^\\(\$*\\)CONFDIR=\"[^\"]*\"#\\1CONFDIR=\"$CONFDIR\"#" \
	-e "s#^\\(\$*\\)VAR_SPOOL_PPR=\"[^\"]*\"#\\1VAR_SPOOL_PPR=\"$VAR_SPOOL_PPR\"#" \
	-e "s#^\\(\$*\\)TEMPDIR=\"[^\"]*\"#\\1TEMPDIR=\"$TEMPDIR\"#" \
	$1 >$2	# infile, outfile

    # Make it executable
    chmod 755 $2

    # This is so that if we are root, ppr will own the file
    chown $USER_PPR $2
    chgrp $GROUP_PPOP $2
    }

# Select a version of echo that will do
# what we need for this script.  This is important 
# if /bin/sh is bash since bash's internal echo does
# not understand backslash escapes.  This variable will
# be filled in by installscript.
EECHO=""
NECHO=""

# Print banner
echo "===================================================="
echo "= Setting up filters                               ="
echo "===================================================="

# look for dpost
echo "Searching for dpost"
if [ -x /usr/lib/lp/postscript/dpost ]
    then
    DPOST="/usr/lib/lp/postscript/dpost"
    $EECHO "\tFound $DPOST"
    else
    DPOST=""
    $EECHO "\tNot found"
    fi

# look for postreverse
echo "Searching for postreverse"
if [ -x /usr/lib/lp/postscript/postreverse ]
    then
    POSTREVERSE="/usr/lib/lp/postscript/postreverse"
    $EECHO "\tFound $POSTREVERSE"
    else
    POSTREVERSE=""
    $EECHO "\tNot found"
    fi

# look for the postplot filter from system V lp
echo "Searching for postplot"
if [ -x /usr/lib/lp/postscript/postplot ]
    then
    POSTPLOT="/usr/lib/lp/postscript/postplot"
    $EECHO "\tFound $POSTPLOT"
    else
    POSTPLOT=""
    $EECHO "\tNot found"
    fi

# Find the programs
TROFF=`findprog troff`
GROFF=`findprog groff`
GROPS=`findprog grops`
TEX=`findprog tex`
LATEX=`findprog latex`
TEXI2DVI=`findprog texi2dvi`
DVIPS=`findprog dvips`

# Look for picture converters
DJPEG=`findprog djpeg`
GIFTOPNM=`findprog giftopnm`
if [ -z "$GIFTOPNM" ]; then GITTOPNM=`findprog giftoppm`; fi
PPMTOPGM=`findprog ppmtopgm`
PNMTOPS=`findprog pnmtops`
BMPTOPPM=`findprog bmptoppm`
XBMTOPBM=`findprog xbmtopbm`
XPMTOPPM=`findprog xpmtoppm`
XWDTOPNM=`findprog xwdtopnm`
PNMDEPTH=`findprog pnmdepth`
TIFFTOPNM=`findprog tifftopnm`

# Look for plot converters
PLOT2PS=`findprog plot2ps`
FIG2DEV=`findprog fig2dev`

# If we have both Troff and Groff, eliminate Troff
# if it is just a link to GNU troff.
if [ -n "$TROFF" -a -n "$GROFF" ]
    then
    if $TROFF -v /dev/null 2>&1 | grep GNU >/dev/null
	then
	$EECHO "\nTroff is a link to GNU troff"
	TROFF=""
	fi
    fi

# Choose a Troff
while [ -n "$TROFF" -a -n "$GROFF" ]
    do
    $EECHO "\nBoth Troff and Groff were found.  Please choose"
    $EECHO "which program to use to convert Troff documents"
    $EECHO "to PostScript.\n"
    $EECHO "\t1 Troff\n"
    $EECHO "\t2 Groff\n"

    $NECHO -n "> "
    read answer

    case "$answer" in
	1 )
	    GROFF=""		# prevent use of Groff
	    ;;
	2 )
	    TROFF=""		# prevent use of Troff
	    ;;
        esac		
    done

# Choose a Ditroff output to PostScript converter
while [ -n "$DPOST" -a -n "$POSTREVERSE" -a -n "$GROPS" ]
    do
    $EECHO "\nPlease choose the program which will be used to convert"
    $EECHO "Ditroff output to PostScript.\n"
    $EECHO "\t1 dpost/postreverse (From the LP spooling system)\n"
    $EECHO "\t2 grops (From Groff package)\n"

    $NECHO -n "> "
    read answer

    case "$answer" in
	1 )
	    GROPS=""
	    ;;
	2 )
	    DPOST=""
	    POSTREVERSE=""
	    ;;
	esac
    done

# Choose a plot filter
while [ -n "$POSTPLOT" -a -n "$PLOT2PS" ]
    do
    $EECHO "\nPlease choose a program to convert plot files"
    $EECHO "to PostScript.\n"
    $EECHO "\t1 $POSTPLOT (From the LP spooling system)\n"
    $EECHO "\t2 $PLOT2PS\n"

    $NECHO -n "> "
    read answer

    case "$answer" in
	1 )
	    PLOT2PS=""
	    ;;
	2 )
	    POSTPLOT=""
	    ;;
	esac
    done

# Separate next section
echo

# Install Ditroff output filter
rm -f $HOMEDIR/lib/filter_ditroff	# remove old filter
DITROFF=""				# say we don't have one yet

if [ -n "$DPOST" -a -n "$POSTREVERSE" ]	# try dpost/postreverse
    then
    echo "Installing filter for Ditroff output (dpost, postreverse)"
    sedit $HOMEDIR/install/filter_ditroff_real $HOMEDIR/lib/filter_ditroff
    DITROFF="YES"
    fi

if [ -n "$GROPS" ]			# try Grops
    then
    echo "Installing filter for Ditroff output (grops)"
    sedit $HOMEDIR/install/filter_ditroff_groff $HOMEDIR/lib/filter_ditroff
    DITROFF="YES"
    fi

if [ -z "$DITROFF" ]
    then
    echo "No Ditroff output filter"
    fi

# Install Troff filter
# This is only installed if the Ditroff output filter was installed
rm -f $HOMEDIR/lib/filter_troff		# remove old filter
HAVETROFF=""				# say we don't have one yet

if [ -n "$TROFF" -a -n "$DITROFF" ]
    then
    echo "Installing Troff filter (AT&T troff)"
    # find the Troff components
    EQN=`findprog eqn`
    REFER=`findprog refer`
    TBL=`findprog tbl`
    PIC=`findprog pic`
    CAT=`findprog cat`
    # substitute cat for those we don't have
    if [ -z "$EQN" ]; then EQN="$CAT"; fi
    if [ -z "$TBL" ]; then TBL="$CAT"; fi
    if [ -z "$REFER" ]; then REFER="$CAT"; fi
    if [ -z "$PIC" ]; then PIC="$CAT"; fi
    sedit $HOMEDIR/install/filter_troff_real $HOMEDIR/lib/filter_troff
    HAVETROFF="YES"
    fi

if [ -n "$GROFF" -a -n "$DITROFF" ]
    then
    echo "Installing Troff filter (groff)"
    sedit $HOMEDIR/install/filter_troff_groff $HOMEDIR/lib/filter_troff
    HAVETROFF="YES"
    fi

if [ -z "$HAVETROFF" ]
    then
    echo "No Troff filter"
    fi

# Install DVI filter
rm -f $HOMEDIR/lib/filter_dvi		# remove old one
DVI=""					# say we don't have one yet

if [ -n "$DVIPS" ]			# try dvips
    then
    echo "Installing DVIPS DVI filter"
    sedit $HOMEDIR/install/filter_dvi $HOMEDIR/lib/filter_dvi
    DVI="YES"
    else
    echo "No DVI filter"
    fi

# Install TeX filter
# This is only installed if the DVI filter was installed
rm -f $HOMEDIR/lib/filter_tex

if [ -n "$TEX" -a -n "$LATEX" -a -n "$DVI" ]
    then
    echo "Installing TeX/LaTeX filter"
    sedit $HOMEDIR/install/filter_tex $HOMEDIR/lib/filter_tex
    else
    echo "No TeX/LaTeX filter"
    fi

# Install TexInfo filter
rm -f $HOMEDIR/lib/filter_texinfo

if [ -n "$TEXI2DVI" -a -n "$DVI" ]
    then
    echo "Installing TexInfo filter"
    sedit $HOMEDIR/install/filter_texinfo $HOMEDIR/lib/filter_texinfo
    else
    echo "No Texinfo filter"
    fi

# Install JPEG filter
rm -f $HOMEDIR/lib/filter_jpeg		# remove old filter

if [ -n "$DJPEG" -a -n "$PNMTOPS" ]
    then
    echo "Installing JPEG filter"
    sedit $HOMEDIR/install/filter_jpeg $HOMEDIR/lib/filter_jpeg
    else
    echo "No JPEG filter"
    fi

# Install GIF filter
rm -f $HOMEDIR/lib/filter_gif		# remove old filter

if [ -n "$GIFTOPNM" -a -n "$PPMTOPGM" -a -n "$PNMTOPS" ]
    then
    echo "Installing GIF filter"
    sedit $HOMEDIR/install/filter_gif $HOMEDIR/lib/filter_gif
    else
    echo "No GIF filter"
    fi

# Install BMP filter
rm -f $HOMEDIR/lib/filter_bmp		# remove old filter

if [ -n "$BMPTOPPM" -a -n "$PPMTOPGM" -a -n "$PNMTOPS" ]
    then
    echo "Installing BMP filter"
    sedit $HOMEDIR/install/filter_bmp $HOMEDIR/lib/filter_bmp
    else
    echo "No BMP filter"
    fi

# Install PNM filter
rm -f $HOMEDIR/lib/filter_pnm		# remove old filter

if [ -n "$PPMTOPGM" -a -n "$PNMDEPTH" -a -n "$PNMTOPS" ]
    then
    echo "Installing PNM filter"
    sedit $HOMEDIR/install/filter_pnm $HOMEDIR/lib/filter_pnm
    else
    echo "No PNM filter"
    fi

# Install XBM filter
rm -f $HOMEDIR/lib/filter_xbm		# remove old filter

if [ -n "$XBMTOPBM" -a -n "$PNMTOPS" ]
    then
    echo "Installing XBM filter"
    sedit $HOMEDIR/install/filter_xbm $HOMEDIR/lib/filter_xbm
    else
    echo "No XBM filter"
    fi

# Install XPM filter
rm -f $HOMEDIR/lib/filter_xpm		# remove old filter

if [ -n "$XPMTOPPM" -a -n "$PPMTOPGM" -a -n "$PNMDEPTH" -a -n "$PNMTOPS" ]
    then
    echo "Installing XPM filter"
    sedit $HOMEDIR/install/filter_xpm $HOMEDIR/lib/filter_xpm
    else
    echo "No XPM filter"
    fi

# Install XWD filter
rm -f $HOMEDIR/lib/filter_xwd		# remove old filter

if [ -n "$XWDTOPNM" -a -n "$PPMTOPGM" -a -n "$PNMDEPTH" -a -n "$PNMTOPS" ]
    then
    echo "Installing XWD filter"
    sedit $HOMEDIR/install/filter_xwd $HOMEDIR/lib/filter_xwd
    else
    echo "No XWD filter"
    fi

# Install TIFF filter
rm -f $HOMEDIR/lib/filter_tiff		# remove old filter

if [ -n "$TIFFTOPNM" -a -n "$PPMTOPGM" -a -n "$PNMDEPTH" -a -n "$PNMTOPS" ]
    then
    echo "Installing TIFF filter"
    sedit $HOMEDIR/install/filter_tiff $HOMEDIR/lib/filter_tiff
    else
    echo "No TIFF filter"
    fi

# Install plot filter
rm -f $HOMEDIR/lib/filter_plot		# remove old filter

if [ -n "$PLOT2PS" ]
    then
    echo "Installing Plot filter (plot2ps)"
    sedit $HOMEDIR/install/filter_plot_plot2ps $HOMEDIR/lib/filter_plot
    else
    if [ -n "$POSTPLOT" ]
	then
	echo "Installing Plot filter (postplot)"
	sedit $HOMEDIR/install/filter_plot_postplot $HOMEDIR/lib/filter_plot
	else
	echo "No Plot filter"
	fi
    fi

# FIG filter
rm -f $HOMEDIR/lib/filter_fig		# remove old filter

if [ -n "$FIG2DEV" ]
    then
    echo "Installing FIG filter"
    sedit $HOMEDIR/install/filter_fig $HOMEDIR/lib/filter_fig
    else
    echo "No FIG filter"
    fi

# we are done
exit 0
