#!/bin/sh
#
# ~ppr/src/makedirs
# Copyright 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# This file was last modified 12 December 1996.
#

#
# This script is called by the top level PPR Makefile to
# create the directories necessary to build and install PPR.
#

HOMEDIR=`sed -ne 's/^HOMEDIR=\(.*\)$/\1/p' include/global.mk`
CONFDIR=`sed -ne 's/^CONFDIR=\(.*\)$/\1/p' include/global.mk`
VAR_SPOOL_PPR=`sed -ne 's/^VAR_SPOOL_PPR=\(.*\)$/\1/p' include/global.mk`

if [ -z "$HOMEDIR" ]
    then
    echo "You haven't run Configure yet."
    exit 1
    fi

# This function returns "ok" if the directory in question
# exists and we have full access to it.
dirnotok ()
    {
    if [ -w $1 -a -r $1 -a -x $1 -a -d $1 ]
	then
	echo "ok"
	fi
    }

# This function creates a directory
directory ()
    {
    echo "$1"
    if [ ! -d $1 ]
	then
	mkdir $1
	fi
    chmod 755 $1
    }

# Try to make them but don't react badly if it doesn't work,
# that is handled in the next section.
mkdir $HOMEDIR $CONFDIR $VAR_SPOOL_PPR 2>/dev/null

# Make sure the directories exist
if [ -z "`dirnotok $HOMEDIR`" -o -z "`dirnotok $CONFDIR`" -o -z "`dirnotok $VAR_SPOOL_PPR`" ]
	then
	echo "Before this script can be run, root must"
	echo "create the directories $HOMEDIR, $VAR_SPOOL_PPR,"
	echo "and $CONFDIR and make sure they are writable by you."
	exit 1
	fi

# It is necessary to create empty configuration
# directories.
directory $CONFDIR/printers
directory $CONFDIR/groups
directory $CONFDIR/mounted

# Make the directories for the permanent cache.
directory $HOMEDIR/cache
directory $HOMEDIR/cache/font
directory $HOMEDIR/cache/procset
directory $HOMEDIR/cache/file
directory $HOMEDIR/cache/encoding

# Make the miscelaineous directories in /usr/ppr.
directory $HOMEDIR/bin
directory $HOMEDIR/lib
directory $HOMEDIR/interfaces
directory $HOMEDIR/responders
directory $HOMEDIR/commentators
directory $HOMEDIR/install
directory $HOMEDIR/PPDFiles

# Make the directories in the spool area.
directory $VAR_SPOOL_PPR/alerts
directory $VAR_SPOOL_PPR/logs
directory $VAR_SPOOL_PPR/cache
directory $VAR_SPOOL_PPR/cache/font
directory $VAR_SPOOL_PPR/cache/procset
#directory $VAR_SPOOL_PPR/cache/file
directory $VAR_SPOOL_PPR/cache/encoding
directory $VAR_SPOOL_PPR/dvips
directory $VAR_SPOOL_PPR/addr_cache

exit 0
