#!/bin/sh
#
# ~ppr/src/installprogs/installscript.sh
# Copyright 1995, 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# This file last modified 3 December 1996.
#

#
# This shell script installs a shell script, modifying it as it is
# installed so that certain path definitions will be correct.  The
# correct values for these path definitions are taken from
# ../include/global.mk.
#

# This is one place to change these.  They must also be changed
# in include/global_defines.h.
USER_PPR="ppr"
GROUP_PPOP="ppop"
GROUP_PPAD="ppad"
GROUP_PPRPROX="pprprox"

# Find an echo that will support "echo -n"
findNECHO ()
    {
    for i in "echo" "/bin/echo" "/usr/ucb/echo"
	do
	if [ -x $i ]
	    then
	    if [ `$i -n | wc -l` -eq 0 ]
		then
		echo $i
		return
		fi
	    fi
	done
    echo echo			# give up
    }
NECHO=`findNECHO`

# Find an echo that will support escapes
findEECHO ()
    {
    for i in "echo" "/bin/echo" "/usr/ucb/echo"
	do
	if [ -x $i ]
	    then
	    if [ `$i '\n' | wc -l` -eq 2 ]
		then
		echo $i
		return
		fi
	    fi
	done
    echo echo			# give up
    }
EECHO=`findEECHO`

HOMEDIR=`sed -ne 's/^HOMEDIR=\(.*\)$/\1/p' ../include/global.mk`
CONFDIR=`sed -ne 's/^CONFDIR=\(.*\)$/\1/p' ../include/global.mk`
VAR_SPOOL_PPR=`sed -ne 's/^VAR_SPOOL_PPR=\(.*\)$/\1/p' ../include/global.mk`
TEMPDIR=`sed -ne 's/^TEMPDIR=\(.*\)$/\1/p' ../include/global.mk`
BINDIR=`sed -ne 's/^BINDIR=\(.*\)$/\1/p' ../include/global.mk`
XWINBINDIR=`sed -ne 's/^XWINBINDIR=\(.*\)$/\1/p' ../include/global.mk`
SIGUSR1=`sed -ne 's/^SIGUSR1=\([0-9]*\)$/\1/p' ../include/global.mk`
SIGUSR2=`sed -ne 's/^SIGUSR2=\([0-9]*\)$/\1/p' ../include/global.mk`
MAILX=`sed -ne 's/^MAILX=\(.*\)$/\1/p' ../include/global.mk`

# default values
SIGUSR1=${SIGUSR1:-16}
SIGUSR2=${SIGUSR2:-17}

#echo "\"$SIGUSR1\" \"$SIGUSR2\""

# Run a shell script thru Sed, changing the program paths
sed -e "s#^\\(\$*\\)HOMEDIR *= *\"[^\"]*\"#\\1HOMEDIR=\"$HOMEDIR\"#" \
    -e "s#^\\(\$*\\)CONFDIR *= *\"[^\"]*\"#\\1CONFDIR=\"$CONFDIR\"#" \
    -e "s#^\\(\$*\\)VAR_SPOOL_PPR *= *\"[^\"]*\"#\\1VAR_SPOOL_PPR=\"$VAR_SPOOL_PPR\"#" \
    -e "s#^\\(\$*\\)TEMPDIR *= *\"[^\"]*\"#\\1TEMPDIR=\"$TEMPDIR\"#" \
    -e "s#^\\(\$*\\)BINDIR *= *\"[^\"]*\"#\\1BINDIR=\"$BINDIR\"#" \
    -e "s#^\\(\$*\\)XWINBINDIR *= *\"[^\"]*\"#\\1XWINBINDIR=\"$XWINBINDIR\"#" \
    -e "s#^\\(\$*\\)NECHO *= *\"[^\"]*\"#\\1NECHO=\"$NECHO\"#" \
    -e "s#^\\(\$*\\)EECHO *= *\"[^\"]*\"#\\1EECHO=\"$EECHO\"#" \
    -e "s#^\\(\$*\\)SIGUSR1 *= *.*#\\1SIGUSR1=$SIGUSR1#" \
    -e "s#^\\(\$*\\)SIGUSR2 *= *.*#\\1SIGUSR2=$SIGUSR2#" \
    -e "s#^\\(\$*\\)USER_PPR *= *.*#\\1USER_PPR=$USER_PPR#" \
    -e "s#^\\(\$*\\)GROUP_PPOP *= *.*#\\1GROUP_PPOP=$GROUP_PPOP#" \
    -e "s#^\\(\$*\\)GROUP_PPAD *= *.*#\\1GROUP_PPAD=$GROUP_PPAD#" \
    -e "s#^\\(\$*\\)GROUP_PPRPROX *= *.*#\\1GROUP_PPRPROX=$GROUP_PPRPROX#" \
    -e "s#^MAILX=.*#MAILX=$MAILX#" \
    $1 >$2	# infile, outfile

# Make it executable
chmod 755 $2

# This is so that if we are root, ppr will own the file
# If "ppr" has not been created yet, we don't want to
# here about it.
chown ppr $2 2>/dev/null

# Disclose USL trade secret:
exit 0
