#!/bin/sh
#
# ~ppr/src/installprogs/fixup.sh
# Copyright 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software and documentation are provided "as is" without
# express or implied warranty.
#
# Last modified 2 April 1997.
#

#
# Script to perform the final stage of PPR installation.
#

# PPR home directory.
# It is normally "/usr/ppr".
HOMEDIR="?"

# PPR configuration directory.
# It is normally "/etc/ppr".
CONFDIR="?"

# PPR spooling directory.
# It is normaly "/var/spool/ppr".
VAR_SPOOL_PPR="?"

# Directory into which to put symbolic links to PPR executables.
# It is normally "/usr/bin".
BINDIR="?"

# Versions of echo
NECHO="?"
EECHO="?"

# Users and groups.  These will be filled in by installscript.sh.
USER_PPR="?"
GROUP_PPOP="?"
GROUP_PPAD="?"
GROUP_PPRPROX="?"

id | egrep '^uid=0\(' >/dev/null
if [ $? -ne 0 ]
    then
    echo "Your are not root."
    exit 1
    fi
   
# Figure out if we have AT&T/NCR LAN Manager for Unix.
if [ -x /usr/bin/net ]
    then
    LANMAN=true
    else
    LANMAN=false
    fi

# Figure out if we have a System V init and what directories it uses:
INIT_BASE=""
for i in /etc /etc/rc.d /sbin
    do
    if [ -d $i/init.d ]
	then
	INIT_BASE=$i
	fi
    done

#
# If we have a System V style init, determine which one it is 
# and come up with a list of links.
#
# More accuration information about run levels and the startup
# order is needed.  Please contribute a corrected INIT_LIST line
# for your system.
#
if [ -n "$INIT_BASE" ]
    then
	# OSF/1 3.2
    	if [ "$INIT_BASE" = "/sbin" ]
	then
	# Needs checking:
	INIT_LIST="rc3.d/S65ppr rc0.d/K00ppr rc2.d/K00ppr"
	else

	# RedHat Linux
	if [ "$INIT_BASE" = "/etc/rc.d" ]
	then
	# Needs checking:
	INIT_LIST="rc2.d/S80ppr rc3.d/S80ppr rc4.d/S80ppr rc5.d/S80ppr rc0.d/K40ppr rc1.d/K40ppr rc6.d/K40ppr"
	else

	if [ "$INIT_BASE" = "/etc" ]
	then

	# Debian Linux
	if [ -x /usr/bin/dpkg -a -x /usr/sbin/update-rc.d ]
	then
	# Needs checking:
	INIT_LIST="rc2.d/S80ppr rc3.d/S80ppr rc4.d/S80ppr rc5.d/S80ppr rc0.d/K20ppr rc6.d/K20ppr"
	else

	# Solaris 2.x, Generic System V
	INIT_LIST="rc2.d/S80ppr rc0.d/K20ppr"
	fi
	fi
	fi
	fi
    fi

# If no System V style init, look for rc.local:
RC_LOCAL=""
# Traditional BSD
if [ -f /etc/rc.local ]
    then
    RC_LOCAL="/etc/rc.local"
    else
    if [ -f /etc/rc.d/rc.local ]
	then
	RC_LOCAL="/etc/rc.d/rc.local"
	fi
    fi

clear
echo "                    Trinity College PPR Spooler"
echo
echo "Copyright 1995, 1996, 1997, Trinity College Computing Center."
echo
echo Permission to use, copy, modify, and distribute this software and its
echo documentation for any purpose and without fee is hereby granted, provided
echo that the above copyright notice appear in all copies and that both that
echo copyright notice and this permission notice appear in supporting
echo documentation.  This software is provided "as is" without express or
echo implied warranty.
echo
echo "This script will prepare PPR for use.  It should be run after a binary"
echo "distribution archive is unpacked or the source code is compiled"
echo "and installed.  It's purpose is to create a Unix account for PPR,"
echo "make sure file permissions are correct, create some symbolic links"
$NECHO -n "in $BINDIR, and "

if [ -n "$INIT_BASE" ]
    then
    echo "install files in $INIT_BASE/init.d and"
    echo "related directories to start PPR at boot time."
    else
    if [ -n "$RC_LOCAL" ]
	then
	echo "add instructions to $RC_LOCAL to start PPR"
	echo "at boot time."
	else
	echo "... oops, more on that later."
	fi
    fi
echo 

# If we have LAN Manager for Unix, we will promise to do extra things.
if $LANMAN
    then
    echo "If you have LAN Manager for Unix it will also create a LAN Manager"
    echo "account for PPR, and log PPR in as a LAN Manager administrator"
    echo "so that messages may be sent to clients."
    echo
    fi

$NECHO -n "In order to sucessfully run this script, you must be root"
if $LANMAN
    then
    $EECHO "and\nroot must be logged on as a LAN Manager admin."
    else
    echo "."
    fi
echo

# If the user doesn't say yes, get out.
$NECHO -n "Do you want to run this PPR installation fixup procedure? "
read answer
if [ -z "$answer" -o "`echo $answer | tr '[A-Z]' '[a-z]' | cut -c1`" != 'y' ]
    then
    exit 0
    fi

# We are under way.  Clear the screen.
clear

# Do a little sanity checking.
if [ ! -d $HOMEDIR ]
    then
    echo "The directory \"$HOMEDIR\" does not exist.  You should not attempt"
    echo "to run this script until all the PPR files are in place."
    exit 1
    fi

# Another sanity check.
if [ ! -d $VAR_SPOOL_PPR ]
    then
    echo "The directory $VAR_SPOOL_PPR does not exist.  You are not ready"
    echo "to run this script."
    exit 1
    fi

# Another sanity check.
if [ ! -d $CONFDIR ]
    then
    echo "The directory $CONFDIR does not exist.  You are not ready to"
    echo "run this script."
    exit 1
    fi

#=============================================================================
# Make sure there is are groups called "pprprox", "ppop", and "ppad".
#=============================================================================

for group in $GROUP_PPRPROX $GROUP_PPOP $GROUP_PPAD
	do
	grep "^$group:" /etc/group >/dev/null
	if [ $? -ne 0 ]
		then
		echo "Adding group \"$group\"."

		if [ -x /usr/sbin/groupadd ]
			then
			/usr/sbin/groupadd $group
			else
			echo "Oops, this script doesn't contain instructions for"
			echo "adding groups on this system.  Please add the groups"
			echo "\"$GROUP_PPRPROX\", \"$GROUP_PPOP\", and \"$GROUP_PPAD\" and run fixup again."
			exit 1
			fi
		fi

	done

PPOP_GID=`awk -F: "/^$GROUP_PPOP:/ { print \\\$3 }" /etc/group`

if [ -z "$PPOP_GID" -o "$PPOP_GID" -eq 0 ]
	then
	echo
	echo "Your groupadd command is broken.  Please edit /etc/group"
	echo "and fix the group id numbers for the groups \"$GROUP_PPRPROX\","
	echo "\"$GROUP_PPOP\", and \"$GROUP_PPAD\" and then run fixup again."
	echo
	exit 1
	fi

#=======================================================================
# We will add the account if this is a System V Release 4 system
# or other system which provides /usr/sbin/passmgmt, for other
# systems, we will let the user do it.
#=======================================================================

echo "A Unix account will now be added for PPR."
if grep "^$USER_PPR:" /etc/passwd >/dev/null
    then
    PPRACCT="existing"
    echo "The account already exists, good."

    # doesn't exist
    else
    PPRACCT="new"

    # if we have passmgmt,
    if [ -x /usr/sbin/passmgmt ]
	then			# have passmgmt
	/usr/sbin/passmgmt -a -h $HOMEDIR -c 'PPR Spooling System' -g $PPOP_GID $USER_PPR
	exitval=$?

	else
	if [ -x /usr/sbin/useradd ]
	    then		# have useradd
	    /usr/sbin/useradd -d $HOMEDIR -c 'PPR Spooling System' -g $PPOP_GID $USER_PPR
	    exitval=$?

	    else		# no user passmgmt or useradd
	    echo
	    echo "Oops!  This script does not contains instructions for"
	    echo "adding accounts on this system, please add an account"
	    echo "called \"$USER_PPR\" and run this script again."
	    exit 1
	    fi
	fi

    # did passmgmt or useradd work?
    if [ $exitval -ne 0 ]	# if error occured, stop the script
	then
	exit 1
	fi

    fi
echo
echo

#=============================================================================
# Change a lot of file permisions
#=============================================================================

echo "Changing the owner of all PPR files to \"$USER_PPR\"."
chown -R $USER_PPR $HOMEDIR
chgrp -R $GROUP_PPOP $HOMEDIR
chmod 755 $HOMEDIR

chown -R $USER_PPR $VAR_SPOOL_PPR
chgrp -R $GROUP_PPOP $VAR_SPOOL_PPR
chmod 755 $VAR_SPOOL_PPR

chown -R $USER_PPR $CONFDIR
chgrp -R $GROUP_PPOP $CONFDIR
chmod 755 $CONFDIR

#
# Create a directory for client spooling.
#
if [ ! -d $VAR_SPOOL_PPR/pprclipr ]
    then
    mkdir $VAR_SPOOL_PPR/pprclipr
    fi
chmod 755 $VAR_SPOOL_PPR/pprclipr
chown $USER_PPR $VAR_SPOOL_PPR/pprclipr
chgrp $GROUP_PPOP $VAR_SPOOL_PPR/pprclipr

#
# Make sure the programs which are supposed
# to be setuid to ppr and setgid to ppop are.
#
chmod 6711 $HOMEDIR/bin/pprd $HOMEDIR/bin/ppr $HOMEDIR/bin/ppop
chmod 6711 $HOMEDIR/bin/ppad $HOMEDIR/bin/ppuser
if [ -x $HOMEDIR/bin/papsrv ]
    then
    chmod 6711 $HOMEDIR/bin/papsrv
    fi
chmod 6711 $HOMEDIR/bin/ppr2samba

# The LPR interface must be setuid root
# so that it can allocate privledged sockets.
chown root $HOMEDIR/interfaces/lpr
chmod 4711 $HOMEDIR/interfaces/lpr

# The xpprgrant program must be setuid root too.
chown root $HOMEDIR/bin/xpprgrant
chmod 4711 $HOMEDIR/bin/xpprgrant

echo "Done."
echo

#===========================================================================
# Remove files which are no longer used in the current version
#===========================================================================
echo "Removing outdated files:"

echo "$VAR_SPOOL_PPR/pprd.lock"
rm -f $VAR_SPOOL_PPR/pprd.lock

echo "$VAR_SPOOL_PPR/cache/file"
rm -rf $VAR_SPOOL_PPR/cache/file

echo "$BINDIR/xppr $BINDIR/xpprstat"
rm -f $BINDIR/xppr $BINDIR/xpprstat

echo "$HOMEDIR/interfaces/parallel $HOMEDIR/interfaces/gs"
rm -f $HOMEDIR/interfaces/parallel $HOMEDIR/interfaces/gs

echo "$HOMEDIR/PPDFiles/HP DeskJet 870C Ghostscript"
rm -f "$HOMEDIR/PPDFiles/HP DeskJet 870C Ghostscript"

echo "Done."
echo

#===========================================================================
# Rename files whose names have changed in the current version:
#===========================================================================
echo "Renaming configuration files whose names have changed:"

# These the user supplies:
if [ -f $CONFDIR/charge_users ]
	then mv $CONFDIR/charge_users $CONFDIR/charge_users.db
	echo mv $CONFDIR/charge_users $CONFDIR/charge_users.db
	fi

if [ -f $CONFDIR/ttfonts ]
	then mv $CONFDIR/ttfonts $CONFDIR/ttfonts.db
	echo mv $CONFDIR/ttfonts $CONFDIR/ttfonts.db
	fi

if [ -f $CONFDIR/newprn ]
	then mv $CONFDIR/newprn $CONFDIR/newprn.conf
	echo mv $CONFDIR/newprn $CONFDIR/newprn.conf
	fi

if [ -f $CONFDIR/papsrv ]
	then mv $CONFDIR/papsrv $CONFDIR/papsrv.conf
	echo mv $CONFDIR/papsrv $CONFDIR/papsrv.conf
	fi

if [ -f $CONFDIR/papsrv_default_zone ]
	then mv $CONFDIR/papsrv_default_zone $CONFDIR/papsrv_default_zone.conf
	echo mv $CONFDIR/papsrv_default_zone $CONFDIR/papsrv_default_zone.conf
	fi

# These are installed from scratch each time:
if [ -f $CONFDIR/fontsub ]
	then mv $CONFDIR/fontsub $CONFDIR/fontsub-pre-1.30.conf
	echo mv $CONFDIR/fontsub $CONFDIR/fontsub-pre-1.30.conf
	fi

if [ -f $CONFDIR/media ]
	then mv $CONFDIR/media $CONFDIR/media-pre-1.30.db
	echo mv $CONFDIR/media $CONFDIR/media-pre-1.30.db
	fi

if [ -f $CONFDIR/mfmodes ]
	then mv $CONFDIR/mfmodes $CONFDIR/mfmodes-pre-1.30.conf
	echo mv $CONFDIR/mfmodes $CONFDIR/mfmodes-pre-1.30.conf
	fi

echo "Done."
echo

#===========================================================================
# Stuff for LAN Manager for Unix (LANMAN X)
#===========================================================================

# If we found /usr/bin/net, try to add a LAN Manager account.
if $LANMAN
  then
  if [ "$PPRACCT" = "existing" ]
    then
    echo "Since Unix user $USER_PPR already exists, we will not try to"
    echo "add a LAN Manager account."
    echo "Please make sure that the Unix user $USER_PPR is logged on as"
    echo "a LAN Manager user who can use NET SEND."
    echo

    else
    echo "A LAN Manager account is now being added for PPR."
    echo -n "Please supply a password for the new account PPR: "
    read pass
    net user $USER_PPR $pass /add /privilege:admin \
	/fullname:'PPR Spooling System' \
	/homedir:'c:\usr\ppr'

    if [ $? -ne 0 ]
	then
	exit 1
	fi

    echo
    echo "Logging PPR on to LAN Manager."
    su ppr -c "net logon $USER_PPR $pass"
    echo
    fi
  fi

#
# Here we go with more LAN Manager stuff.
# We share the client spooling area.
#
if $LANMAN
    then
    echo "Creating a share name for client spooling."
    net share 'pprclipr=c:\var\spool\ppr\pprclipr'
    net share pprclipr /remark:'PPR client spooling area'
    net access 'c:\var\spool\ppr\pprclipr' /add users:r guests:r
    echo
    fi

#
# If the LAN Manager X print processors directory
# is present, install PPR's print processor.
#
if [ -d /var/opt/lanman/customs ]
    then
    echo "Installing the PPR LAN Manager X print processor."
    cp $HOMEDIR/install/customs.ppr /var/opt/lanman/customs/ppr
    chown root /var/opt/lanman/customs/ppr
    chmod 755 /var/opt/lanman/customs/ppr
    echo
    fi

#===========================================================================
# Attempt to get the system to start PPR when it boots.
#===========================================================================

#
# If we have a System V style init with System V style
# init scripts, install a startup script for PPR and
# make links in the directories for the appropriate
# run levels.
#
if [ -n "$INIT_BASE" ]
then
	echo "Installing the start and stop scripts:"

	# Install the principal script:
	echo $INIT_BASE/init.d/ppr
	cp $HOMEDIR/install/etc.init.d.ppr $INIT_BASE/init.d/ppr
	chown root $INIT_BASE/init.d/ppr
	chmod 755 $INIT_BASE/init.d/ppr

	# Remove any old links:
	rm -f $INIT_BASE/rc[0-6].d/[SK][0-9][0-9]ppr

	# Install the new links:
	for f in $INIT_LIST
	    do
	    echo $INIT_BASE/$f
	    rm -f $INIT_BASE/$f
	    ln $INIT_BASE/init.d/ppr $INIT_BASE/$f
	    chown root $INIT_BASE/$f
	    chmod 755 $INIT_BASE/$f
	    done

	# Look for old PPR startup code
	if [ -n "$RC_LOCAL" ]
	    then
	    if egrep -i 'start ppr' $RC_LOCAL >/dev/null
		then
		echo
		echo "There are currently lines in $RC_LOCAL which start"
		echo "PPR.  You should remove these so that PPR does not get"
		echo "started twice."
		echo
		echo "Please press RETURN to continue."
		read x
		fi
	    fi

#
# Otherwise, try to find a Berkeley style rc.local file.
#
else
if [ -n "$RC_LOCAL" ]
    then
    if egrep -i 'start ppr' $RC_LOCAL >/dev/null
	then
	echo "Commands to start PPR already exist in $RC_LOCAL."
	echo "After this script is done, please make sure they are correct."
	echo "In particular, make sure that the program paths are correct."
	if egrep -i "$CONFDIR/papsrv[^.]" $RC_LOCAL >/dev/null
	    then
	    echo "Also, change all references to \"$CONFDIR/papsrv\" to \"$CONFDIR/papsrv.conf\"."
	    fi
	echo
	echo "Please press RETURN to continue."
	read x

	else
	echo "Appending PPR startup commands to $RCLOCAL"
	{
	echo
	echo "# Start PPR"
	echo "if [ -x $HOMEDIR/bin/pprd ]"
	echo " then"
	echo " echo \"Starting PPRD\""
	echo " $HOMEDIR/bin/pprd"
	echo " fi"
	echo "if [ -x $HOMEDIR/bin/papsrv -a -r $CONFDIR/papsrv.conf ]"
	echo " then"
	echo " echo \"Starting PAPSRV\""
	echo " $HOMEDIR/bin/papsrv"
	echo " fi"
	} >>$RCLOCAL

	fi

#
# No identifiable init script system.
#
    else
	clear
	echo "Since your system doesn't seem to use a System V style"
	echo "init nor do you have have an rc.local file, you must find"
	echo "your own means to start PPR when the system boots."
	echo "You must arrange for root to run $HOMEDIR/bin/pprd"
	echo "and possibly $HOMEDIR/bin/papsrv."
	echo
	echo "Please press RETURN to continue."
	read x
    fi

fi
echo

#======================================================================
# Create links so that the PPR bin directory need
# not be in the PATH.
#======================================================================
echo "Creating symbolic links in $BINDIR"
echo "ln -s $HOMEDIR/bin/ppr $BINDIR/ppr"
rm -f $BINDIR/ppr
ln -s $HOMEDIR/bin/ppr $BINDIR/ppr
echo "ln -s $HOMEDIR/bin/ppop $BINDIR/ppop"
rm -f $BINDIR/ppop
ln -s $HOMEDIR/bin/ppop $BINDIR/ppop
echo "ln -s $HOMEDIR/bin/ppad $BINDIR/ppad"
rm -f $BINDIR/ppad
ln -s $HOMEDIR/bin/ppad $BINDIR/ppad
echo "ln -s $HOMEDIR/bin/ppuser $BINDIR/ppuser"
rm -f $BINDIR/ppuser
ln -s $HOMEDIR/bin/ppuser $BINDIR/ppuser
echo

#=========================================================================
# Run the filter setup script.
#=========================================================================

echo
echo "Your current PATH will now be searched for programs which can"
echo "be used to convert various file formats to PostScript."
echo
echo "Please press RETURN to continue."
read x
clear
$HOMEDIR/install/setup_filters

#=========================================================================
# Might as well be plain about it:  we are done.
#=========================================================================
echo
echo "PPR installation done.  You may now start the spooler."
echo

# Disclose USL trade secret:
exit 0
