#!/bin/sh
#
# ~ppr/src/installprogs/etc.init.d.ppr.sh
# Copyright 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 31 January 1997.
#

#
# This file is designed to work with the System V init provided with 
# operating systems such as SunOS 5.  If invoked with the argument
# "start", it starts PPRD and PAPSRV, if invoked with the argument
# "stop", it is supposed to stop them.  The "/usr/ppr/install/fixup"
# script will install this script if necessary.
#

# Things to be filled in when installed:
HOMEDIR="?"
CONFDIR="?"
VAR_SPOOL_PPR="?"
NECHO="?"

case "$1" in
    start)
	$NECHO -n "Starting PPR daemons: "
        $HOMEDIR/bin/pprd && $NECHO -n "pprd "
	if [ -x $HOMEDIR/bin/papsrv -a -r $CONFDIR/papsrv.conf ]
	    then
            $HOMEDIR/bin/papsrv && $NECHO -n "papsrv "
	    fi
	# Uncomment this if you want to run lprsrv in standalone mode:
	# $HOMEDIR/lib/lprsrv -s printer -S `$HOMEDIR/lib/lprsrv --hostname` && $NECHO -n "lprsrv "
	echo
	# For RedHat Linux:
	if [ -d /var/lock/subsys ]; then touch /var/lock/subsys/ppr; fi
        exit 0
        ;;
    stop)
	$NECHO -n "Stopping PPR daemons: "
	if [ -r $VAR_SPOOL_PPR/pprd.pid ]
	    then
	    kill `cat $VAR_SPOOL_PPR/pprd.pid` && $NECHO -n "pprd "
	    rm -f $VAR_SPOOL_PPR/pprd.pid
	    fi
	if [ -r $VAR_SPOOL_PPR/papsrv.pid ]
	    then
	    kill `cat $VAR_SPOOL_PPR/papsrv.pid` && $NECHO -n "papsrv "
	    rm -f $VAR_SPOOL_PPR/papsrv.pid
	    fi
	if [ -r $VAR_SPOOL_PPR/lprsrv.pid ]
	    then
	    kill `cat $VAR_SPOOL_PPR/lprsrv.pid` && $NECHO -n "lprsrv "
	    rm -f $VAR_SPOOL_PPR/lprsrv.pid
	    fi
	echo
	# For RedHat Linux:
	if [ -d /var/lock/subsys ]; then rm -f /var/lock/subsys/ppr; fi
	exit 0
	;;
    *)
        echo "Usage: ppr {start, stop}"
        exit 1
        ;;
esac

# end of file
