/*
** ~ppr/src/include/sysdep.h
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 27 February 1997.
*/

/*
** Try to define some things properly for the
** system we are compiling on.
**
** Note that this file is not named in any of the make files.  That
** means that if you modify it you will have to do a "make clean".
**
** Here is a list of the defines which are used to select system
** dependent code or file names in PPR:
**
** #define signal(x,y) sigset(x,y)
**			On System V we need this macro to get Posix
**			style signal handling.  On Linux the definition
**			is even more compicated then this example.
** #define HAVE_STATVFS	1
**			use statvfs() to find disk free space
** #define HAVE_STATFS 1
**			use statfs() to find disk free space
**			You may define one of the above but not both.
** #define HAVE_VFS_H 1
**			use vfs.h instead of mount.h for statfs()
** #define MAILPATH "/usr/lib/sendmail"
**			the path to sendmail or compatible program
**			If you wish to change this, you must #undef
**			it first since it is already defined as
**			"/usr/lib/sendmail".
** #define TLI_PROTOS_MISSING 1
**			include files don't have modern prototypes 
**			for certain TLI functions
** #define NEEDS_STRSIGNAL 1
**			strsignal() is not in library.  If this is set,
**			PPR will provide one.
** #define NO_POLL 1	use select() and SIGIO instead of poll() and SIGPOLL
** #define USE_LPR 1	have lprsrv send non-PPR jobs to lpr
**			in stead of lp
** #define NO_TERMIOS 1	no termios.h and its functions
**			(Currently, none of the systems define this.)
** #define USE_SOCKET_FIFO 1
**			use a socket instead of Posix FIFOs
**			(Not fully supported.)
** #define NO_PUTENV 1	putenv() does not exist
** #define USE_SPAWN 1	use spawn() instead of fork() and exec()
**			(Not fully supported.)
** #define NO_FORK 1	C library does not have a working fork() function.
**			(Not fully supported.)
** #define USE_SOCKETPAIR_SIGIO 1
**			SIGIO doesn't work on pipes but does on
**			Unix domain socket pairs.  If this is defined,
**			PPR will use a socket pair in some places
** 			where it would otherwise use an ordinary pipe.
** #define SHORT_PATH "/bin:/usr/bin"
**			Defines a nice, secure path for filters, interfaces,
**			responders, and other children of ppr and pprd.
**			Other reasonable values are "/bin" 
**			and "/bin:/usr/bin:/usr/local/bin".
** #define LATE_UNLINK 1
**			This should be defined if unlink()ing an open file
**			is not allowed causes bad things to happen.  Though
**			common in Unix implementations, the ability to remove
**			all names for an open file is not a Posix requirement.
**			(This define is not fully implemented.)
** #define BACKSPACE 1
**			Define this if ppop and ppad should do a stty to set 
**			the backspace to control-h when entering interactive
**			mode.
*/

/*========================================================================
** AT&T System V Release 4.0 for the AT&T WGS series
** of 386/486 microcomputers.
========================================================================*/
#ifdef __svr4__
#ifdef __i386__		/* AT&T Sys V release 4 for 80[34]86 WGS */

/* /bin is a link to /usr/bin */
#undef SHORT_PATH
#define SHORT_PATH "/usr/bin"

/*
** In System V, release 4, the signal() function behaves oddly,
** presumably to maintain compatibility with old programs.
** the sigset() function behaves the way the signal() function
** does in most modern unixes.
*/
#define signal(x,y) sigset(x,y)

/* We have statvfs(), unlike BSD which has statfs(). */
#define HAVE_STATVFS 1

/*
** The people who packaged this unix up seem to think that their
** mail program is better than Sendmail, so they tuck Sendmail
** into an out of the way corner.
*/
#undef MAILPATH
#define MAILPATH "/usr/ucblib/sendmail"

/*
** This version has a lot of errors in its include files.
** We will provide prototypes for a number of functions whose
** protypes are missing from the include files.
** For the socket functions, we must include sys/socket.h now
** in order for the definitions to make sense.
*/
int fchmod(int fildes, mode_t mode);
#include <sys/socket.h>
int getpeername(int s, struct sockaddr *name, int *namelen);
int socket(int domain, int type, int protocol);
int connect(int s, struct sockaddr *name, int namelen);
int setsockopt(int s, int level, int optname, char *optval, int optlen);

#define TLI_PROTOS_MISSING 1

#define NEEDS_STRSIGNAL 1

#define BACKSPACE 1

int select(int nfds, fd_set *readfds, *writefds, execptfds, struct timeval *timeout);

#endif /* __i386__ */
#endif /* __svr4__ */

/*========================================================================
** SunOS 5.x (Solaris 2.x)
========================================================================*/
#ifdef __svr4__
#ifdef __sun__

/* /bin is a link to /usr/bin */
#undef SHORT_PATH
#define SHORT_PATH "/usr/bin"

/* Don't use the silly System V signal(). */
#define signal(x,y) sigset(x,y)

/* We have statvfs(), unlike BSD which has statfs(). */
#define HAVE_STATVFS 1

#endif
#endif

/*====================================================================
** 386BSD, NetBSD, FreeBSD
** Not really tested.
** Do NetBSD and FreeBSD still define __386BSD__?
====================================================================*/
#ifdef __386BSD__
#define setsid() setpgrp(0,getpid()) /* setsid() (Posix?) is missing */
#define HAVE_STATFS 1		/* we have statfs() (SysV has statvfs()) */
#define NO_POLL 1		/* no poll() system call */
#undef MAILPATH
#define MAILPATH "/usr/sbin/sendmail"
#define USE_LPR 1		/* system uses lpr instead of lp */
#endif

/*====================================================================
** Linux
** This port has received heavy use, but not as heavy as the
** System V Release 4 for AT&T WGS and Sunos 5 ports.
====================================================================*/
#ifdef __linux__
/*
** Linux has a mongrul signal system.  It is half BSD and half SysV.
** Here we define a BSD compatible signal().
*/
#define signal(A,B) {struct sigaction act; sigemptyset(&act.sa_mask); act.sa_flags=0; act.sa_handler=B; sigaction(A,&act,(struct sigaction*)NULL);}

#define HAVE_STATFS 1		/* we have statfs() (SysV has statvfs()) */
#define HAVE_VFS_H 1		/* use vfs.h instead of mount.h for stafs() */

#define NO_POLL 1		/* no poll() system call */

/*
** The following line is necessary for Linux 1.1.85 but will
** presumably become unnecessary at some time in the future.
*/
#define USE_SOCKETPAIR_SIGIO 1 	/* SIGIO doesn't work on pipes */

#define USE_LPR 1		/* tell lprsrv system uses lpr instead of lp */

#endif

/*========================================================================
** SunOS 4.1.3_U1
========================================================================*/
#ifdef __sun__
#ifndef  __svr4__

#undef SHORT_PATH
#define SHORT_PATH "/usr/bin"

#define HAVE_STATFS 1
#define HAVE_VFS_H 1

#define NEEDS_STRSIGNAL 1

#define OPEN_MAX _POSIX_OPEN_MAX

#endif
#endif

/*========================================================================
** OSF/1 3.2 for DEC Alpha
========================================================================*/
#ifdef __osf__
#ifdef __alpha

/* /bin is a link to /usr/bin */
#undef SHORT_PATH
#define SHORT_PATH "/usr/bin"

/* Don't use System V signal(). */
#define signal(x,y) sigset(x,y)

#define NEEDS_STRSIGNAL 1

#define HAVE_STATVFS 1

#define OPEN_MAX sysconf(_SC_OPEN_MAX)

int ioctl(int fd, int request, ...);

#endif
#endif

/*==========================================================================
** MS-Windows 95/NT with Cygnus GNU tools.
==========================================================================*/
#ifdef __CYGWIN32__
#define OPEN_MAX 60		/* who knows */
#define WCOREDUMP(a) 0		/* not supported */
#define signal(A,B) {struct sigaction act; sigemptyset(&act.sa_mask); act.sa_flags=0; act.sa_handler=B; sigaction(A,&act,(struct sigaction*)NULL);}
#define NO_POLL			/* not System V style SIGPOLL */
#define SIGIO NSIG		/* fake value */
#define NEEDS_STRSIGNAL 1	/* function is missing */
#define seteuid(i) 0
#define setegid(i) 0
#endif

/*==========================================================================
** SGI IRIX 6.3
==========================================================================*/
#ifdef __sgi
#define signal(A,B) {struct sigaction act; sigemptyset(&act.sa_mask); act.sa_flags=0; act.sa_handler=B; sigaction(A,&act,(struct sigaction*)NULL);}
#define HAVE_STATVFS 1		/* we have statvfs() */
#define NEEDS_STRSIGNAL 1

/* /bin is a link to /usr/bin */
#undef SHORT_PATH
#define SHORT_PATH "/usr/bin"

#endif

/* end of file */
