/*
** ~ppr/src/include/rpprd.h
** Copyright 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
**
** Last revised 23 September 1996.
*/

/* */
#define RPPRD_LOGFILE LOGDIR"/rpprd"
#define RPPRD_PORT 50042

/* Should we do any debugging? */
#define DEBUG 1

#ifdef DEBUG
#define DODEBUG(a) debug a
#else
#define DODEBUG(a)
#endif

/* Structure for each file descriptor: */
struct FD
	{
	int used;
	char *name;		/* name of file or host (for debugging) */
	void (*read)(int fd, int extra);
	int read_extra;
	void (*write)(int fd, int extra);
	int write_extra;
	void (*exception)(int fd, int extra);
	int exception_extra;
	} ;
	
/* Structure for each job in a queue: */
struct JOB
	{
	int destnode;
	char *dest;
	int id;
	int subid;
	int homenode;
	} ;

/* Possible states of a copy to operashun: */
enum COPY_STATE {COPY_TO_NAME, COPY_TO_READING, COPY_TO_WRITING, COPY_TO_EOF} ;

/* Structure to describe the copying of a file to a remote system: */
struct COPY_TO
	{
	struct NODE *node;		/* node being copied to */
	struct JOB *job;		/* job being copied */
	char buffer[512];		/* buffer for copying */
	enum COPY_STATE state;		/* state of copy operashun */
	} ;

/* Possible states of the node connexion: */
enum NODE_STATE {NODE_OPENING, NODE_AUTHENTICATION, NODE_COPY_QUEUE, NODE_COPY_COMMENTS,
	NODE_COPY_PAGES, NODE_COPY_TEXT, NODE_COPY_INFILE,
	NODE_COPY_DONE};

/* Structure for each remote node: */
struct NODE
	{
	int id;			/* ID number of this node */
	int fd;			/* file desciptor of connexion */
	enum NODE_STATE state;	/* State of the connexion */
	struct COPY_TO copy_to;	/* structure describing copying */
	} ;

/* Functions in rpprd.c: */
void debug(const char *string, ...);

/* Functions in rpprd_sendjob.c: */
void send_job(const char *command);

/* end of file */
