/*
** ~ppr/src/include/pprdrv.h
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last revised 12 March 1997.
*/

/* 
** No debugging code will be compiled in if DEBUG
** is not defined.  Not even the function debug()
** will be compiled! 
*/
/* #define DEBUG 1 */

/*
** Uncomment the defines for the debugging
** code you want to have included.  Most of
** these defines will control the definition
** of a macro at the end of this file.
*/
#ifdef DEBUG
/* #define DEBUG_TRUETYPE 1 */		/* truetype fonts, conversion to Postscript */
#define DEBUG_MAIN 1			/* main() */
/* #define DEBUG_PPD 1 */		/* PPD file parsing */
#define DEBUG_INTERFACE 1		/* show opening, closing, etc. */
/* #define DEBUG_INTERFACE_GRITTY 1 */	/* interface operation in excessive detail */
/* #define DEBUG_FLAGS 1 */		/* banner and trailer pages */
/* #define DEBUG_RESOURCES 1 */		/* fonts, procset, etc. */
/* #define DEBUG_QUERY 1 */		/* patch queries? */
#define DEBUG_FEEDBACK 1		/* show twoway operations */
#define DEBUG_FEEDBACK_LINES 1		/* show the lines read from printer */
/* #define DEBUG_BINSELECT_INLINE 1 */	/* add comments to output */
/* #define DEBUG_SIGNITURE_INLINE 1 */
/* #define DEBUG_LW_MESSAGES 1 */	/* message regularization */
/* #define DEBUG_LW_MESSAGES_GRITTY 1 */
/* #define DEBUG_DIE_DELAY 60 */	/* seconds to delay after receiving sigterm */
#define DEBUG_COMMENTARY 1
#endif

#define PPRDRV_LOGFILE LOGDIR"/pprdrv"

/*
** It is difficult to know how high to set these.
**
** Steve Hsieh reports a printer with more than 20 "*PaperDimension:" lines.
** Version 4.1 of the PPD spec. lists about 60 specific sizes but suggests
** that many more are possible.
**
** I have yet to see a printer with more than 45 fonts (QMS-PS 410), so 
** the hash table size of 64 is probably adequate, especially since 
** it is not a hard limit.
**
** It is concievable that a large patch could be longer than 8192,
** requiring MAX_PPDTEXT to be increased.  Probably this limit should
** be removed altogether.
*/
#define PPD_TABSIZE 128		/* slots in PPD file string hash table */
#define FONT_TABSIZE 64		/* slots in font hash table */
#define MAX_PPDNAME 50		/* max length of PPD string name */
#define MAX_PPDTEXT 8192	/* max length of PPD string value (including multiline values) */
#define MAX_DRVREQ 40		/* maximum # requirements in a document */
#define MAX_PAPERSIZES 100	/* maximum # "*PaperDimension:" lines in PPD file */

/*
** What should be done if we have trouble converting a MS-Windows 
** TrueType font to a PostScript type 42 or type 3 font?  Should 
** we view it as a printer error or as a job error?
**
** This will never happen if you don't have corrupt .TTF files.
** If you do, setting EXIT_TTFONT to EXIT_JOBERR could allow
** other jobs to print if they don't use the defective font.
** If they do they will all be arrested.  Setting EXIT_TTFONT
** to EXIT_PRNERR_NORETRY gives the operator a change to fix
** it before all those jobs get arrested.  Since it is perfectly 
** easy to release an arrested job, Steve Hsieh <steveh@eecs.umich.edu>
** is probably right in advocating EXIT_JOBERR.
*/
/* #define EXIT_TTFONT EXIT_PRNERR_NORETRY */
#define EXIT_TTFONT EXIT_JOBERR

/*==================== No tunables below this line. =====================*/

/* pprdrv.c: */
extern int test_mode;
extern char line[];
extern int line_len;
extern int line_overflow;
char *dgetline(FILE *infile);
char *dgetline_read(FILE *infile);
extern char *QueueFile;
extern struct QFileEntry job;
extern int group_pass;
extern int doing_primary_job;
extern int sheetcount;
extern int print_direction;
void fatal(int exval, const char *str,...);
void debug(const char *str,...);              
void error(const char *string, ... );
extern char *drvreq[MAX_DRVREQ];
extern int drvreq_count;
extern int strip_binselects;	/* for pprdrv_ppd.c */
extern int strip_signature;	/* for pprdrv_ppd.c */
void jobbreak(void);

/* pprdrv_flag.c: */
void print_flag_page(int flagtype, int possition);

/* pprdrv_feedback.c: */
void feedback_start(void);
void feedback_pjl_wait(void);
void close_log(void);

/* pprdrv_ppd.c: */
void add_font(char *fontname);
void new_string(char *name);
void string_line(char *string);
void end_string(void);
void order_dependency_1(int order);
void order_dependency_2(int section);
void order_dependency_3(const char *name1);
void order_dependency_4(const char *name2);
void read_PPD_file(char *name);
char *find_feature(char *name, char *variation);
void begin_stopped(void);
void end_stopped(char *feature, char *option);
void insert_features(FILE *qstream, int set);    
void include_feature(char *featuretype, char *option);
void begin_feature(char *featuretype, char *option, FILE *infile);
void include_resource(void);
int find_font(char *fontname);                  
void papersize_moveto(char *paper);

/* pprdrv_res.c: */
void insert_noinclude_fonts(void);
void insert_extra_prolog_resources(void);
void write_resource_comments(void);
void begin_resource(FILE *infile);
struct DRVRES *add_drvres(int needed, int fixinclude, char *type, char *name, double version, int revision);
int add_resource(char *type, char *name, double version, int revision);
void add_resource_font(char *name);

/* pprdrv_capable.c: */
int check_if_capable(FILE *qfile, int group_pass);

/* pprdrv_media.c: */
int load_mountedlist(void);
int select_media(char *name);
int select_media_by_dsc_name(char *name);
void read_media_lines(FILE *q);
extern struct Media_Xlate media_xlate[];
extern int media_count;

/* pprdrv_buf.c: */
void set_writemon_description(const char *description);
void printer_puts_QuotedValue(const char *str);
void printer_puts_escaped(const char *str);
void printer_putc(int c);
void printer_puts(const char *str);
void printer_putline(const char *str);
void printer_printf(const char *str, ...);
void printer_write(const char *buf, int len);
void printer_flush(void);
void printer_bufinit(void);
void printer_TBCP_on_off(int setto);

/* pprdrv_nup.c: */
void prestart_N_Up_hook(void);
void invoke_N_Up(void);
void close_N_Up(void);

/* pprdrv_req.c: */
void write_requirement_comments(void);

/* pprdrv_signature.c: */
int signature(int sheetnumber,int thissheet);

/* pprdrv_reason.c: */
void give_reason(const char *reason);
void describe_postscript_error(const char *error, const char *command);

/* pprdrv_patch.c: */
void patchfile(void);
void jobpatchfile(void);
int patchfile_query_callback(char *message);

/* pprdrv_commentary.c: */
void commentary(int flags, const char *cooked, const char *raw1, const char *raw2);
void commentator_wait(void);

/* pprdrv_tt.c: */
char *find_ttfont(char *name);
void want_ttrasterizer(void);
void insert_ttfont(char *filename);

/* pprdrv_progress.c: */
void progress__page_start_comment_sent(void);
void progress__pages_truly_printed(int n);
void progress__bytes_sent(int n);
void progress__new_message(const char *text);

/* pprdrv_lw_messages.c: */
char *regularize_lw_message(const char *message_file, const char *raw_message);

/* pprdrv_notppd.c: */
void set_jobname(void);
void set_copies(int copies);

/* pprdrv_persistent.c: */
int persistent_query_callback(char *message);
void persistent_download_now(void);
void persistent_finish(void);

/*
** A record which describes a printer commentator which
** should be fed information about what is going on with
** the printer.
*/
struct COMMENTATOR
	{
	char *progname;		/* "file" or program to invoke */
	char *address;		/* first parameter to feed to it */
	char *options;		/* second parameter to feed to it */
	int interests;		/* bitmask telling which events to invoke for */
	struct COMMENTATOR *next;
	} ;

/*
** The values for the "flags" argument to the commentary() 
** function.  These are used to indicate into which 
** catagory the message falls so that commentary() can decide
** which of the commentators to pass the information to.
*/
#define COM_PRINTER_ERRORS 1		/* printer errors ( %%[ PrinterError: xxxxxx ]%% ) */
#define COM_PRINTER_STATUS 2		/* printer status messages ( %%[ status: xxxxxx ]%% ) */
#define COM_IMPATIENCE 4		/* "printing bogged down" */
#define COM_EXIT 8			/* Why did it exit? */
#define COM_MUNDANE_EXIT 16		/* boring stuff such as printed and incapable */
#define COM_PRINTER_STATUS_UPDATES 32	/* solicited printer status updates */

/*
** the information we compile about the printer and 
** the current job
*/
struct PPRDRV {
        char *Name;                         
        char *Interface;                    /* stuff */
        char *Address;                      /* from */
        char *Options;                      /* printer */
	struct COMMENTATOR *Commentators;   /* the list of processes to tell about things */
        int charge_per_duplex;		    /* duplexed sheet charge in cents */
        int charge_per_simplex;		    /* simplex sheet sharge in cents */
        int do_banner;                      /* configuration */
        int do_trailer;                     /* file */
        int feedback;                       /* true or false */
        int jobbreak;                       /* one of several values */
        int OutputOrder;                    /* 1 or -1 or 0 if unknown */
        char *PPDFile;                      /* name of description file */
	int type42_ok;			    /* Can we use type42 fonts? */
	int GrayOK;			    /* permission to print non-colour jobs? */
        } ;

/* This structure is in pprdrv.c */
extern struct PPRDRV printer;

/*
** A PPD file string entry.
*/
struct PPDSTR {
        char *name;
        char *value;
        struct PPDSTR *next;
        } ;

/*
** A PPD file font entry.
*/
struct PPDFONT {
        char *name;
        struct PPDFONT *next;
        } ;

/*
** The list of device features 
*/
struct FEATURES {
    int ColorDevice;                /* TRUE or FALSE, real colour printing */
    int Extensions;                 /* 0 or EXTENSION_* */
    int FaxSupport;                 /* FAXSUPPORT_* */
    int FileSystem;                 /* TRUE or FALSE */
    int LanguageLevel;              /* 1, 2, etc. */
    int TTRasterizer;		    /* TT_NONE, TT_ACCEPT68K, TT_TYPE42 */
    } ;

/* This structure is in pprdrv_ppd.c */
extern struct FEATURES Features;

/*
** Structure to describe a mounted media list entry.
** The mounted media list files are generated by pprd,
** but pprd uses two fwrite calles for each record and does
** not use this structure.
*/
struct MOUNTED
    {
    char bin[MAX_BINNAME];
    char media[MAX_MEDIANAME];
    } ;

/* this structure is in pprdrv_media.c */
extern struct MOUNTED mounted[MAX_BINS];

/*
** Structure used by pprdrv to describe a resource:
*/
struct DRVRES
    {
    char *type;			/* procset, font, etc. */
    char *name;			/* name of this resource */
    double version;		/* procset only, 0.0 for others */
    int revision;		/* procset only, 0 for others */
    int needed;			/* TRUE or FALSE */
    int fixinclude;		/* TRUE or FALSE, add inclusion to docset?  */
    int force_into_docsetup;	/* TRUE or FALSE, relocate inclusion to docsetup? */
    char *former_name;		/* name of substituted resource */
    char *subcode;		/* PostScript code for font substitution */
    char *filename;		/* NULL or file to load cached resource from */
    int truetype;		/* Resource is a TrueType font to be converted to type 42 */
    int mactt;			/* Resource is a TrueType font converted by a Mac to PostScript */
    int force_into_prolog;	/* Insert resource in prolog */
    } ;

extern struct DRVRES *drvres;	/* in pprdrv.c */
extern int drvres_count;	/* in pprdrv.c */
extern int drvres_space;	/* in pprdrv.c */

/*
** Structure in pprdrv_ppd.c for paper sizes.
**
** An array of these structures contains a list of
** the paper sizes enumerated in this printer's 
** PPD file.
*/
struct PAPERSIZE
    {
    char *name;			/* name of paper size */
    double width;		/* width in 1/72ths */
    double height;
    double lm;			/* left margin */
    double tm;			/* top margin */
    double rm;			/* right margin */
    double bm;			/* bottom margin */
    } ;

extern struct PAPERSIZE papersize[];
extern int papersizex;
extern int num_papersizes;

/*
** This structure contains information we will use
** to monitor how well writes are progressing.
**
** That is how we generate those commentary messages
** about stalled printers.
*/
struct WRITEMON
    {
    int interval;
    int impatience;
    } ;
    
extern struct WRITEMON writemon;    

/*
** The structure which is used to translate between PPR media names and 
** the media names in the "%%Media:" lines.
*/
struct 	Media_Xlate {
	char *pprname;
	char *dscname;
	} ;

/*
** Define the debugging macros based on what was chosen above.
*/
#ifdef DEBUG_TRUETYPE
#define DODEBUG_TRUETYPE(a) debug a
#else
#define DODEBUG_TRUETYPE(a)
#endif

#ifdef DEBUG_MAIN
#define DODEBUG_MAIN(a) debug a
#else
#define DODEBUG_MAIN(a)
#endif

#ifdef DEBUG_PPD
#define DODEBUG_PPD(a) debug a
#else
#define DODEBUG_PPD(a)
#endif

#ifdef DEBUG_INTERFACE
#define DODEBUG_INTERFACE(a) debug a
#else
#define DODEBUG_INTERFACE(a)
#endif

#ifdef DEBUG_INTERFACE_GRITTY
#define DODEBUG_INTERFACE_GRITTY(a) debug a
#else
#define DODEBUG_INTERFACE_GRITTY(a)
#endif

#ifdef DEBUG_FLAGS
#define DODEBUG_FLAGS(a) debug a
#else
#define DODEBUG_FLAGS(a)
#endif

#ifdef DEBUG_RESOURCES
#define DODEBUG_RESOURCES(a) debug a
#else
#define DODEBUG_RESOURCES(a)
#endif

#ifdef DEBUG_QUERY
#define DODEBUG_QUERY(a) debug a
#else
#define DODEBUG_QUERY(a)
#endif

#ifdef DEBUG_FEEDBACK
#define DODEBUG_FEEDBACK(a) debug a
#else
#define DODEBUG_FEEDBACK(a)
#endif

#ifdef DEBUG_COMMENTARY
#define DODEBUG_COMMENTARY(a) debug a
#else
#define DODEBUG_COMMENTARY(a)
#endif

/* Values used to descibe the second argument to "*OrderDependency:": */
#define ORD_EXITSERVER 1
#define ORD_PROLOG 2
#define ORD_DOCUMENTSETUP 3
#define ORD_PAGESETUP 4
#define ORD_JCLSETUP 5
#define ORD_ANYSETUP 6

/* end of file */
