/*
** ~ppr/src/include/pprd.h
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Part of PostScript printing system, written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 12 March 1997.
*/

/*
** Values and structures used only by pprd and ppop.
** pprd.c and ppop.c include this file after global_defines.h
*/

/* This you might want to change */
#define TICK_INTERVAL 5			/* seconds between calls to tick() */
#define UPGRADE_INTERVAL 20		/* number of ticks to gain one pri point */
#define RETRY_MULTIPLIER 30		/* extra seconds per retry */
#define MIN_RETRY 600			/* retry at least this often (seconds) */
#define ENGAGED_RETRY 60		/* interval to retry ``otherwise engaged'' printers */
#define MAX_ACTIVE 15			/* maximum simultainiously active printers */
#define STARVING_RETRY_INTERVAL 5	/* how often to retry starving printers */
#define ENGAGED_NAG_TIME 20		/* Engaged time to qualify as "remaining printer problem" */

#define QUEUE_SIZE_INITIAL 200		/* entries allocated at startup */
#define QUEUE_SIZE_GROWBY 50		/* additional entries allocated at each overflow */
#define QUEUE_SIZE_MAX 10000		/* absolute maximum size we will attempt to allocate */

/* #define DEBUG 1 */

/*
** pprd Debugging Options. 
*/
#ifdef DEBUG
/* #define DEBUG_PROGINIT 1 */		/* initialization routines */
#define DEBUG_PPRDMAIN 1		/* main loop */
/* #define DEBUG_RECOVER 1 */		/* reloading jobs and mounted media on restart */
#define DEBUG_NEWJOBS 1			/* receipt of new jobs */
/* #define DEBUG_PRNSTART 1 */		/* starting of printers */
/* #define DEBUG_PRNSTART_GRITTY 1 */   /* details of starting printers */
#define DEBUG_PRNSTOP 1			/* analysis of pprdrv exit */
#define DEBUG_DEQUEUE 1			/* removal from the queue */
/* #define DEBUG_MEDIA 1 */             /* media operations */
/* #define DEBUG_TICK 1 */		/* debug timer tick routine */
/* #define DEBUG_RESPOND 1 */		/* launching of responders */
#define DEBUG_PPOPINT 1			/* interface to ppop */
/* #define DEBUG_ALERTS 1 */
#endif

/*
** The name of the debugging output file.  Even if all of the above
** debugging options are turned off, some output will still be sent
** to this file.
*/
#define PPRD_LOGFILE LOGDIR"/pprd"

/*============ User: don't change anything below this line. ============*/

/* Values for the first argument to fatal(). */
#define ERROR_DIE 0
#define ERROR_DUMPCORE 100

/* structure to describe a printer */
struct Printer
    {
    char name[MAX_DESTNAME+1];  /* name of the printer */
    int alert_interval;         /* every this many retries */
    char *alert_method;         /* means of communicating with operator */
    char *alert_address;        /* address of operator */
    int protect;                /* TRUE if "Charge:" line in conf file */
    int charge_per_duplex;	/* per-sheet charge */
    int charge_per_simplex;	/* half-sheet charge */
    int accepting;              /* TRUE if is accepting as destination */
    int nbins;                  /* number of bins */
    int bins[MAX_BINS];         /* binname id of each bin */
    int AutoSelect_exists;	/* TRUE if any bin is named "AutoSelect" */
    int media[MAX_BINS];        /* media id of media in each bin */
    int previous_status;	/* saved previous status */
    int status;                 /* idle, disabled, etc */
    int cancel_job;		/* cancel the job at pprdrv exit */
    int next_error_retry;	/* number of next retry */
    int next_engaged_retry;	/* number of times otherwise engaged or off-line */
    int countdown;              /* seconds till next retry */
    pid_t pid;                  /* pid of process driving the printer */
    int jobdestid;              /* dest id of the job we are printing */
    int id;			/* queue id of job being printed */
    int subid;			/* queue subid of job being printed */
    int homenode_id;		/* id number of node which submitted the job */
    pid_t ppop_pid;             /* send SIGUSR1 to this process when stopt */
    } ;

/* a group */
struct Group
    {
    char name[MAX_DESTNAME+1];		/* name of group */
    char accepting;			/* TRUE if accepting new jobs */
    char held;				/* TRUE if jobs for group held */
    short int printers[MAX_GROUPSIZE];	/* printer id's of members */
    int members;			/* number of members */
    char rotate;			/* TRUE if we should use in rotation */
    char last;				/* member offset of member last used */
    char protect;			/* TRUE if we should restrict use */
    char deleted;			/* TRUE if group has been deleted */
    } ;

/* A queue entry as stored by pprd and passed back to ppop. */
struct QEntry
    {
    short int destid;		/* destination key number */
    short int id;		/* queue id */
    short int subid;		/* fractional queue id */
    short int homenode_id;	/* id of node job come from */
    short int priority;		/* priority number (0=highest, 39=lowest */
    short int status;		/* printer id if printing, < 0 other */
    unsigned char never;	/* bitmap of group member which can't print */
    unsigned char notnow;	/* bitmap of group members without media mntd */
    short int media[MAX_DOCMEDIA]; /* list of id numbers of media types req. */
    short int pass;		/* number of current pass thru printers in group */
    } ;

/* 
** Structures for response to the "f" command.
** Used by pprd and ppop.
*/
struct fcommand1
    {
    int nbins;                      /* number of bins in this printer */
    char prnname[MAX_DESTNAME+1];   /* name of the printer */
    } ;
struct fcommand2
    {
    char bin[MAX_BINNAME+1];        /* name of this bin */
    char media[MAX_MEDIANAME+1];    /* name of mounted media */
    } ;

/*
** Debugging macros.
*/
#ifdef DEBUG_NEWJOB
#define DODEBUG_NEWJOB(a) debug a
#else
#define DODEBUG_NEWJOB(a)
#endif

#ifdef DEBUG_DEQUEUE
#define DODEBUG_DEQUEUE(a) debug a
#else
#define DODEBUG_DEQUEUE(a)
#endif

#ifdef DEBUG_MEDIA
#define DODEBUG_MEDIA(a) debug a
#else
#define DODEBUG_MEDIA(a)
#endif

#ifdef DEBUG_PROGINIT
#define DODEBUG_PROGINIT(a) debug a
#else
#define DODEBUG_PROGINIT(a)
#endif

#ifdef DEBUG_RESPOND
#define DODEBUG_RESPOND(a) debug a
#else
#define DODEBUG_RESPOND(a)
#endif

#ifdef DEBUG_ALERTS
#define DODEBUG_ALERTS(a) debug a
#else
#define DODEBUG_ALERTS(a)
#endif

#ifdef DEBUG_PPOPINT
#define DODEBUG_PPOPINT(a) debug a
#else
#define DODEBUG_PPOPINT(a)
#endif

#ifdef DEBUG_PRNSTART
#define DODEBUG_PRNSTART(a) debug a
#else
#define DODEBUG_PRNSTART(a)
#endif

/* end of file */
