/*
** ~ppr/src/include/ppop.h
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
**
** This file was last modified 12 December 1996.
*/

/*
** This is the include file for all the modules in the ppop utility.
*/

struct Jobname
    {
    char destnode[MAX_NODENAME+1];
    char destname[MAX_DESTNAME+1];
    int id;
    int subid;
    char homenode[MAX_NODENAME+1];
    } ;

struct Destname
    {
    char destnode[MAX_NODENAME+1];
    char destname[MAX_NODENAME+1];
    } ;

/* Things in ppop.c: */
extern pid_t pid;
extern int machine_readable;
extern FILE *errors;
extern int A_switch_value;
FILE *get_ready(const char *nodename);
FILE *wait_for_pprd(int do_timeout);
int print_reply(void);
int parse_job_name(struct Jobname *job, const char *jobname);
int parse_dest_name(struct Destname *dest, const char *destname);
int assert_am_operator(void);
int job_permission_check(struct Jobname *job);
int is_my_job(struct QEntry *qentry, struct QFileEntry *qfileentry);
int privledged(void);

/* Command routines in ppop_cmds_listq.c: */
int ppop_short(char *argv[]);
int ppop_details(char *argv[]);
int ppop_list(char *argv[],int suppress);
int ppop_lpq(char *argv[]);
int ppop_qquery(char *argv[]);
int ppop_progress(char *argv[]);

/* This is needed by some commands in ppop_cmds_other.c: */
int custom_list(char *argv[],
		void(*help)(void),
		void(*banner)(void),
		int(*item)(struct QEntry *qentry,
		    struct QFileEntry*,
		    char *onprinter,
                    FILE *qstream),
		int suppress,
		int arrested_drop_time);

/* Command routines in ppop_cmds_other.c: */
int ppop_status(char *argv[]);
int ppop_message(char *argv[]);
int ppop_media(char *argv[]);
int ppop_mount(char *argv[]);
int ppop_start_stop_wstop_halt(char *argv[], int variation);
int ppop_cancel(char *argv[], int inform);
int ppop_purge(char *argv[], int inform);
int ppop_clean(char *argv[]);
int ppop_cancel_active(char *argv[], int my, int inform);
int ppop_move(char *argv[]);
int ppop_rush(char *argv[]);
int ppop_hold_release(char *argv[], int release);
int ppop_accept_reject(char *argv[], int reject);
int ppop_destination(char *argv[], int comment_too);
int ppop_alerts(char *argv[]);
int ppop_log(char *argv[]);

/* end of file */
