/*
** ~ppr/src/include/ppad.h
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This file was last modified 12 November 1996.
*/

/*
** This is the header file for the PPR administrator's utility ppad.
*/

/* functions and global variables in ppad.c */
int am_operator(void);
extern FILE *errors;
extern int machine_readable;
extern int debug_level;

/* functions in ppad_media.c */
int media_show(char *argv[]);
int media_put(char *argv[]);
int media_delete(char *argv[]);
int media_export(void);

/* functions in ppad_printer.c */
int printer_show(char *argv[]);
int printer_comment(char *argv[]);
int printer_interface(char *argv[]);
int printer_options(char *argv[]);
int printer_jobbreak(char *argv[]);
int printer_feedback(char *argv[]);
int printer_ppd(char *argv[]);
int printer_alerts(char *argv[]);
int printer_frequency(char *argv[]);
int printer_flags(char *argv[]);
int printer_outputorder(char *argv[]);
int printer_charge(char *argv[]);
int printer_bins_ppd(char *argv[]);
int printer_bins_add(char *argv[]);
int printer_bins_delete(char *argv[]);
int printer_delete(char *argv[]);
int printer_new_alerts(char *argv[]);
int printer_touch(char *argv[]);
int printer_switchset(char *argv[]);
int printer_deffiltopts(char *argv[]);
int printer_ppdopts(char *argv[]);

/* functions in ppad_group.c */
int group_show(char *argv[]);
int group_comment(char *argv[]);
int group_rotate(char *argv[]);
int group_add(char *argv[]);
int group_remove(char *argv[]);
int _group_remove(char *group, char *member);
int group_delete(char *argv[]);
int group_touch(char *argv[]);
int group_switchset(char *argv[]);
int _group_deffiltopts(char *group);
int group_deffiltopts(char *argv[]);

/* functions in ppad_conf.c */
int prnopen(char *prnname,int);
int grpopen(char *grpname,int);
int confread(void);
int confwrite(char *string,...);
int confclose(void);
int confabort(void);
int ppop2(char *parm1, char *parm2);
extern char confline[];
void write_fifo(char *string,...);
int make_switchset_line(char *line, char *argv[]);
void print_switchset(char *switchset);
void print_deffiltopts(char *deffiltopts);

/* functions in ppad_filt.c */
void deffiltopts_open(void);
int deffiltopts_add_ppd(const char *name, const char *InstalledMemory);
int deffiltopts_add_printer(const char *name);
char *deffiltopts_line(void);
void deffiltopts_close(void);

/* end of file */
