/*
** ~ppr/src/include/interfaces.h
** Copyright 1995, 1996, 1997, Trinity College Computing Center
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This file was last modified 12 September 1996.
*/

/*
** This is a list of the supplied interfaces and their characteristics.
** This allows jobbreak and feedback to be set automatically for
** the listed interface programs.
**
** Don't confuse this file with interface.h.
*/
struct {
	char *name;
	char jobbreak;
	char feedback;
	} interfaces[]={
    	    	    	{"simple",  	JOBBREAK_CONTROL_D, 	FALSE},
    	    	    	{"atalk",	JOBBREAK_SIGNAL,	TRUE},
			{"parallel",	JOBBREAK_CONTROL_D,	FALSE},
			{"serial",	JOBBREAK_CONTROL_D,	TRUE},
			{"client",	JOBBREAK_CONTROL_D,	FALSE},
			{"lpr",		JOBBREAK_CONTROL_D,	FALSE},
			{"tcpip",	JOBBREAK_CONTROL_D,	TRUE},
			{"gssimple",	JOBBREAK_NEWINTERFACE,	TRUE},
			{"gsparallel",	JOBBREAK_NEWINTERFACE,	TRUE},
			{"gstcpip",	JOBBREAK_NEWINTERFACE,	TRUE},
			{"gsatalk",	JOBBREAK_NEWINTERFACE,	TRUE},
			{"dummy",	JOBBREAK_NONE,		FALSE},
			{(char*)NULL,0,0} };
			
/* end of file */
