/*
** ~ppr/src/include/global_structs.h
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 27 February 1997.
*/

/*
** There are no configuration parameters in this file.
*/

/*
** A queue entry as used by pprdrv and ppop.  This is quite
** detailed, pprd uses a very abreviated queue entry structure.
*/
struct QFileEntry
    {
    const char *destnode;		/* node this job will be sent to */
    const char *destname;		/* destination (group or printer) */
    int id;				/* queue id number */
    int subid;				/* fractional part of id number */
    const char *homenode;		/* the node this job origionated on */
    int priority;			/* priority number (0-39) */
    long time;				/* time job was submitted (don't use time_t) */
    long user;				/* id of user who submitted it (don't use uid_t) */
    const char *username;		/* text version of "user" */
    const char *proxy_for;		/* -X switch string */
    const char *ForLine;		/* %%For: line for PostScript header */
    const char *charge_to;		/* charge account to debit */
    const char *Routing;		/* %%Routing: line for PostScript header */
    const char *Title;			/* %%Title: for Postscript header */
    const char *Creator;		/* application which created it */
    const char *lpqFileName;		/* name of input file */
    const char *response_method;	/* method of sending message to user */
    const char *response_address;	/* address for errors, possibly NULL */ 
    const char *responder_options;	/* name=value list of responder options */
    int nmedia;				/* number of media types */
    int media[MAX_DOCMEDIA];		/* list of required media types */
    int do_banner;			/* should we print a banner page? */
    int do_trailer;			/* should we print a trailer page? */
    struct {			/* various attributes */
        int langlevel;		/* postscript language level */
        int extensions;		/* bit fields of extension to level 1 */
        float DSClevel;		/* DSC comments version */
        int pages;		/* number of pages, -1 means unknown */
        int pageorder;		/* -1, 0, or 1 */
        int prolog;		/* true if valid prolog section present */
        int docsetup;		/* true if valid document setup section present */
        int script;		/* delineated pages present */
	int proofmode;		/* desired proofmode value */
        int pagefactor;		/* virtual pages per physical sheet */
	int orientation;	/* one of ORIENTATION_* */
	long input_bytes;	/* Size of input file in bytes */
	long postscript_bytes;	/* Size of input PostScript code in bytes */
	int parts;		/* number of sub jobs job was divided into */
        } attr;
    struct {
        int binselect;		/* do automatic bin selection */
        int copies;		/* number of copies to print, -1=unspecified */
        int collate;		/* TRUE if we should collate copies */
	int keep_badfeatures;	/* keep Feature code we can not replace from PPD file */
	unsigned int hacks;	/* enables code to deal with problems */
	int resume;		/* TRUE if should try to resume jobs in the middle */
        } opts;
    struct {			/* N Up parameters */
        int N;			/* virtual pages per physical side */
        int borders;		/* TRUE or false, should we print borders */
        int sigsheets;		/* Number of sheets to user per signiture */
	int sigpart;		/* fronts, backs, both */
        } N_Up;
    struct {			/* Portion to print */
	int odd;
	int even;
	int start;
	int stop;
	} portion;
    const char *Draft;		/* `Draft' string */
    } ;

/* Possible values for orientation member of struct QFileEntry. */
#define ORIENTATION_UNKNOWN 0
#define ORIENTATION_PORTRAIT 1
#define ORIENTATION_LANDSCAPE 2

/* Bitfield values for opts.hacks. */
#define HACK_KEEPINFILE 1
#define HACK_TRANSPARENT 2
#define HACK_BADEPS 4

/* First end of file marker in a transmitted queue file. */
#define QF_ENDTAG1 "..\n"
#define QF_ENDTAG2 ".\n"

/*
** Media file structure to describe one type of media.
** The character arrays are space padded ASCII.
*/
struct Media
    {
    char medianame[MAX_MEDIANAME];  /* from PostScript comment */
    double width;                   /* width in 72nds of an inch */
    double height;                  /* height in 72nds of an inch */
    double weight;                  /* weight grams per square metre */
    char colour[MAX_COLOURNAME];    /* colour name */
    char type[MAX_TYPENAME];        /* type string, preprinted forms */
    int flag_suitability;           /* rank on scale of 1 to 10 */
    } ;

/* Array of structures to describe a list of page sizes. */
struct PAGESIZE
	{
	char *name;		/* "letter" */
	double width;		/* 612.0 */
	double length;		/* 792.0 */
	} ;
extern struct PAGESIZE page_sizes[];

/* 
** More global functions in libppr.a.  These are not defined in
** "global_defines.h" because they take structures as arguments
** and the structures are defined in this file, so if you don't
** include this file, you can't use these functions anyway.
*/
int read_struct_QFileEntry(FILE *qfile, struct QFileEntry *job);
void destroy_struct_QFileEntry(struct QFileEntry *job);

/*
** A structure to describe the computed charge.
*/
struct COMPUTED_CHARGE
	{
	int duplex_sheets;
	int per_duplex;
	int simplex_sheets;
	int per_simplex;
	int total;
	} ;

void compute_charge(struct COMPUTED_CHARGE *charge, int per_duplex_sheet, int per_simplex_sheet, int vpages,
	int n_up_n, int vpages_per_sheet, int sigsheets, int sigpart, int copies);
	
/* end of file */
