/*
** ~ppr/src/include/global_defines.h
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
**
** The PPR project was begun 28 December 1992.
** This file was last modified 4 April 1997.
*/

/*
** There are many things in this file you may want to change.  This file 
** should be the first include file.  It is the header file for the whole 
** project.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>

/*=================================================================
** Things that are a matter of personal preference:
=================================================================*/

/*
** Define if we want the spooler to keep superseeded
** PostScript code as comments.  These comments can be
** useful in debuging.
**
** If you change this you should recompile pprdrv.
*/
#define KEEP_OLD_CODE 1

/*
** The user and group names used for certain purposes.
** If you change any of these be sure to change them in
** installprogs/installscript.sh too.
**
** If you change these you should recompile everything.
*/
#define USER_PPR "ppr"
#define GROUP_PPOP "ppop"
#define GROUP_PPAD "ppad"
#define GROUP_PPRPROX "pprprox"

/*
** Define this if you wish a user's printing privledges to be
** revoked only if he tries to print during business hours when
** he doesn't have any money left in his account.  If this is
** not defined, his privledges are revoked even if he runs out of
** money in the middle of the night.
**
** If you change this you must recompile libpprdb and pprdrv.
*/
#undef BUSINESS_HOURS

/*
** CHARGE_BY_SIDES has been removed since it is no longer necessary.
** See the new form of the ppad charge command.
*/
/* #undef CHARGE_BY_SIDES */

/*
** Do we want to use the job name supplied by lpr or do we want to
** accept a "%%Title:" comment if present?
**
** If you change this you must recompile lprsrv.
*/
#undef LPRSRV_USE_LPR_STYLE_JOB_NAME

/*
** These are used by lprsrv and papsrv.  They will not accept new
** jobs unless at least this many inodes and blocks are free
** in TEMPDIR and VAR_SPOOL_PPR.
**
** If you change these you must recompile papsrv and lprsrv.
*/
#define MIN_INODES 100
#define MIN_BLOCKS 2048 

/* 
** Define if we should include code to make GNU-C happy.
** This generaly means initializing a variable to zero
** in order to supress incorrect warnings about possibly
** uninitialized variables.
*/
#define GNUC_HAPPY 1

/*
** Allow Apple's non-standard quote mark quoting.  (Apple LaserWriter
** drivers may enclose a procset name in ASCII double quotes with the
** PostScript () quotes inside.  Don't change this, you won't like
** the results.
*/
#define APPLE_QUOTE 1

/*======================================================================
** Define various directory and file names.  Those not begining 
** with "/" originate in HOMEDIR due to the simple fact that the
** spooler almost always has that as its current directory.
**
** You don't want to change anything in this section.
======================================================================*/

/*
** First we define some basic directories.  Some of these
** will be defined here only if they have not been defined
** in the Makefiles.
**
** Do not change these here, change them in include/global.mk.
*/
#ifndef HOMEDIR
#define HOMEDIR "/usr/ppr"			/* directory for most permanent files */
#endif
#ifndef CONFDIR
#define CONFDIR "/etc/ppr"			/* top directory for all configuration files (must be absolute) */
#endif
#ifndef VAR_SPOOL_PPR
#define VAR_SPOOL_PPR "/var/spool/ppr"		/* are for fixed path things */
#endif
#ifndef TEMPDIR
#define TEMPDIR "/tmp"				/* for ordinary temporary files */
#endif
#ifndef XWINBINDIR				/* for standard X-Windows programs */
#define XWINBINDIR "/usr/X11/bin"
#endif

/* Special files used by the spooler: */
#define NEXTIDFILE VAR_SPOOL_PPR"/nextid"	/* file with next queue id number */
#define FIFO_NAME VAR_SPOOL_PPR"/PIPE"		/* name of pipe between ppr & pprd */
#define FIFO_NAME_RPPRD VAR_SPOOL_PPR"/PIPE_RPPRD"
#define PPRD_LOCKFILE VAR_SPOOL_PPR"/pprd.pid"	/* created and locked by pprd */

/* Directories where the spooler finds components: */
#define INTDIR "interfaces"			/* directory for interface programs */
#define COMDIR "commentators"			/* directory for commentator programs */
#define RESPONDERDIR "responders"		/* responder programs */
#define PPDDIR HOMEDIR"/PPDFiles"		/* our PPD file library */
#define PRE_CACHEDIR "cache"			/* pre-loaded cache files */

/* Directories where the spooler writes stuff: */
#define QUEUEDIR VAR_SPOOL_PPR"/queue"		/* queue directory */
#define DATADIR VAR_SPOOL_PPR"/jobs"		/* date directory */
#define ALERTDIR VAR_SPOOL_PPR"/alerts"		/* directory for alert files */
#define LOGDIR VAR_SPOOL_PPR"/logs"		/* directory for log files */
#define CACHEDIR VAR_SPOOL_PPR"/cache"		/* directory for automatically cached files */
#define ADDRESS_CACHE VAR_SPOOL_PPR"/addr_cache"

/* Various configuration directories: */
#define PRCONF CONFDIR"/printers"		/* printer configuration files */
#define GRCONF CONFDIR"/groups"			/* group configuration files */
#define MOUNTEDDIR CONFDIR"/mounted"		/* directory for media mounted files */

/* Various configuration files: */
#define DBNAME CONFDIR"/charge_users.db"	/* users database file name */
#define FONTSUB CONFDIR"/fontsub.conf"		/* font substitution database */
#define MEDIAFILE CONFDIR"/media.db"		/* media definitions */
#define TTDBNAME CONFDIR"/ttfonts.db"		/* list of MS-Win TT fonts */
#define LW_ERRORS_FILE CONFDIR"/lw_errors.conf"	/* LaserWriter errors file */
#define LW_STATUS_FILE CONFDIR"/lw_status.conf"	/* LaserWriter status file */
#define NEWPRN_CONFIG CONFDIR"/newprn.conf"	/* new printer configuration lines */
#define MFMODES CONFDIR"/mfmodes.conf"		/* MetaFont modes for various printers */

/* The paths of various programs which must be invoked by other components: */
#define PPRDRV_PATH "lib/pprdrv"
#define PPOP_PATH "bin/ppop"
#define PPR_PATH "bin/ppr"

/* The spooler state file for GUI interface: */
#define STATE_UPDATE_FILE VAR_SPOOL_PPR"/state_update"
#define STATE_UPDATE_MAXLINES 1000
#define STATE_UPDATE_PPRDRV_FILE VAR_SPOOL_PPR"/state_update_pprdrv"
#define STATE_UPDATE_PPRDRV_MAXBYTES 30000

/* If this file exists, it will be filled with a log of all jobs printed: */
#define PRINTLOG_PATH LOGDIR"/printlog"

/*=======================================================================
** System Dependent Stuff
=======================================================================*/

/*
** These are rather system dependent, so sysdep.h
** may redefine many of these.  We define them here
** rather than waiting to defined them conditionally
** after including sysdep.h for philisophical reasons.
** We want to make it plain that these values will
** apply to the vast majority of systems.
*/
#define SHORT_INT short int		/* a 16 bit number */
#define BOOL char
#define MAILPATH "/usr/lib/sendmail"	/* mail program for alerting */
#define SHORT_PATH "/bin:/usr/bin"	/* Secure path */

/*
** Include system dependent modifications to the stuff above
** and special defines necessary to compile on particular systems.
*/
#include "sysdep.h"

/*=====================================================================
** Some Practical Limits
=====================================================================*/

#define MAX_LINE 1024			/* maximum PostScript input line length (now pretty meaningless) */
#define MAX_CONT 32			/* maximum segment represented by "%%+" */
#define MAX_TOKENIZED 512		/* longest line we may pass to tokenize() */
#define MAX_TOKENS 20			/* limit on words per comment line */
#define MAX_PATH 128			/* space to reserve for building a file name */

#define MAX_BINNAME 16			/* max chars in name of input bin */
#define MAX_MEDIANAME 16		/* max chars in media name */
#define MAX_COLOURNAME 16		/* max chars in colour name */
#define MAX_TYPENAME 16			/* max chars media type name */

#define MAX_DOCMEDIA 4			/* max media types per job */

#define MAX_DESTNAME 16			/* max length of destination name */
#define MAX_NODENAME 16			/* max length of node name */
#define MAX_NODES 25			/* max number of nodes pprd can keep track of */
#define MAX_PRINTERS 150		/* no more than 150 printers */
#define MAX_BINS 10			/* max bins per printer */
#define MAX_GROUPS 150			/* no more than this may groups */
#define MAX_GROUPSIZE 8			/* no more than 8 printers per group */

#define MAX_QFLINE 256			/* Max length of queue file line (exclusive of newline and NULL) */
#define MAX_RESPONSE_METHOD 16		/* Max length of method name (responder name) */
#define MAX_RESPONSE_ADDRESS 100	/* Max length of address to pass to responder */
#define MAX_RESPONDER_OPTIONS 100	/* Max length of options list */

#define MAX_CONFLINE 255		/* Max length of config file line (exclusive of newline and NULL) */

#define MAX_STATUS_MESSAGE 80		/* maximum length of last message from printer */

#define MAX_PPD_NEST 10			/* maximum PPD file include levels */
#define MAX_PPD_LINE 255		/* maximum line length for PPD files */
#define MAX_VMOPTIONS 15		/* maximun number of *VMOption lines in PPD file */

/*=========================================================================
** End of values which an end user might want to change.
=========================================================================*/

/*---------------------------------------------------
** Functions in  in libppr.a
---------------------------------------------------*/

/* Structures for ppr_getopt(). */
struct ppr_getopt_opt
	{
	const char *name;
	int code;
	BOOL needsarg;
	} ;
struct ppr_getopt_state
	{
	int argc;					/* private */
	char **argv;					/* private */
	const char *opt_chars;				/* private */
	const struct ppr_getopt_opt *opt_words;		/* private */
	int optind;					/* public */
	char *optarg;					/* public */
	const char *name;				/* public */
	int x;						/* very private */
	int len;					/* very private */
	char scratch[3];				/* very private */
	} ;

/* Function prototypes */
void *myalloc(size_t number, size_t size);
void *myrealloc(void *ptr, size_t number, size_t size);
char *mystrdup(const char *string);
char *mystrndup(const char *string, size_t len);
void myfree(void *ptr);
void myalloc_checkpoint(void);
int myalloc_checkpoint_get(void);
void myalloc_checkpoint_put(int n);
void _myalloc_assert(const char *file, int line, int assertion);
#define myalloc_assert(assertion) _myalloc_assert(__FILE__, __LINE__, assertion)
char *datestamp(void);
void tokenize(void);
extern char *tokens[];
void ASCIIZ_to_padded(char *padded, const char *asciiz, int len);
void padded_to_ASCIIZ(char *asciiz, const char *padded, int len);
int padded_cmp(const char *padded1, const char *padded2, int len);
int ppr_sscanf(const char *string, const char *pattern, ...);
void daemon(void);
void valert(const char printername[], int dateflag, const char string[], va_list args);
void alert(const char printername[], int dateflag, const char string[], ...);
const char *quote(const char *);
double getdouble(const char *);
char *dtostr(double);
int torf(const char *s);
int destination_protected(const char *destnode, const char *destname);
int icmp(const char *s1, const char *s2);
int icmpn(const char *s1, const char *s2, int n);
int lock_exclusive(int filenum, int waitmode);
char *money(int amount_times_ten);
char *local_jobid(const char *destname, int id, int subid, const char *homenode);
char *remote_jobid(const char *destnode, const char *destname, int id, int subid, const char *homenode);
const char *network_destspec(const char *destnode, const char *destname);
int pagesize(const char *keyword, int *width, int *length, int *envelope);
int disk_space(const char *path, unsigned int *free_blocks, unsigned int *free_files);
char *noalloc_find_cached_resource(const char *res_type, const char *res_name, double version, int revision, int *new_revision, mode_t *mode);
char *find_cached_resource(const char *res_type, const char *res_name, double version, int revision, int *new_revision, mode_t *mode);
void wrap_string(char *string, int width);
int get_responder_width(const char *name);
void options_start(const char *options_str);
int options_get_one(char *name, int maxnamelen, char *value, int maxvaluelen);
extern const char *options_string;
extern const char *options_error;
extern int options_error_context_index;
extern int options_error_index;
double convert_dimension(const char *string);
void filter_option_error(int exlevel, const char *format, ...)
#ifdef __GNUC__
__attribute__ ((noreturn))
#endif
;
const char *pap_strerror(int err);
const char *nbp_strerror(int err);
const char *pap_look_string(int n);
char *ppr_get_command(const char *prompt, int machine_input);
const char *ppr_get_nodename(void)
#ifdef __GNUC__
__attribute__ ((const))
#endif
;
int assign_nodeid(char *nodename);
void free_nodeid(int nodeid);
const char *nodeid_to_nodename(int nodeid);
int ppd_open(const char *name, FILE *errors);
char *ppd_readline(void);
void ppr_getopt_init(struct ppr_getopt_state *state, int argc, char **argv, const char *opt_chars, const struct ppr_getopt_opt *opt_words);
int ppr_getopt(struct ppr_getopt_state *state);

/* NEEDS_STRSIGNAL may be defined in sysdep.h */
#ifdef NEEDS_STRSIGNAL
const char *strsignal(int signum);
#endif

/*
** Functions and constants which library callers must provide if they
** call certain library functions.
*/
void fatal(int exitval, const char *string, ...)
#ifdef __GNUC__
__attribute__ (( noreturn, format (printf, 2, 3) ))
#endif
;
void error(const char *string, ...)
#ifdef __GNUC__
__attribute__ ((format (printf, 1, 2)))
#endif
;
extern const int lib_memory_fatal;
extern const int lib_misc_fatal;
extern const int lib_tokenize_fatal;

/*==================================================================
** Sundry constants which the end user should not change because
** they are not options or because changing their values will only
** lead to undesireable results.
==================================================================*/

/* 
** Define if we should include code to make GNU-C happy.
** This generaly means initializing a variable to zero
** in order to supress incorrect warnings about possibly
** uninitialized variables.
*/
#define GNUC_HAPPY 1

/*
** Allow Apple's non-standard quote mark quoting.  (Apple LaserWriter
** drivers may enclose a procset name in ASCII double quotes with the
** PostScript () quotes inside.
*/
#define APPLE_QUOTE 1

/*
** Characters which are not allowed in printer
** and group names:
**
** The tilde is not allowed because at the head of the name it is a 
** shell user name interpolation character and at the end it is an 
** Emacs-style backup file.  A period is not allowed as the initial
** character because it would make for a hidden configuration file.
*/
#define DEST_DISALLOWED "/\n\r\t \b~"
#define DEST_DISALLOWED_LEADING ".-"

/*
** TRUE and FALSE
** The code makes liberal use of these macros.
*/
#if !defined(FALSE)
#define FALSE 0
#endif
#if !defined(TRUE)
#define TRUE !FALSE
#endif

/*
** Define unix permissions 755 and 644.  We do this because just
** saying 0755 or 644 is at least theoretically non-portable and
** because these portable expressions are long and unsightly.
*/
#define UNIX_755 (S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH)
#define UNIX_644 (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP)

/*
** Values for torf(), a function which examines a string
** and tries to determine whether it represents a true or
** a false value.
*/
#define ANSWER_UNKNOWN -1           
#define ANSWER_FALSE 0
#define ANSWER_TRUE 1

/*
** Types of PostScript langauge extensions:
*/
#define EXTENSION_DPS 1
#define EXTENSION_CMYK 2
#define EXTENSION_Composite 4
#define EXTENSION_FileSystem 8

/*
** Types of fax support:
*/
#define FAXSUPPORT_NONE 0
#define FAXSUPPORT_Base 1

/*
** "%%PageOrder:" settings
*/
#define PAGEORDER_ASCEND 1
#define PAGEORDER_DESCEND -1
#define PAGEORDER_SPECIAL 0

/*
** Valid banner and trailer options.
*/
#define BANNER_DONTCARE 0           /* ppr submits the job with one */    
#define BANNER_YESPLEASE 1          /* of these */   
#define BANNER_NOTHANKYOU 2          

#define BANNER_FORBIDDEN 0          /* the printer configuration includes one */      
#define BANNER_DISCOURAGED 1        /* of these */
#define BANNER_ENCOURAGED 2
#define BANNER_REQUIRED 3   
#define BANNER_INVALID 4	    /* used to indicate invalid user input in ppad(8) */

/*
** Job status values.
** A positive value is the ID of a printer which
** is currently printing the job.
*/
#define STATUS_WAITING -1		/* waiting for printer */
#define STATUS_HELD -2			/* put on hold by user */      
#define STATUS_WAITING4MEDIA -3		/* proper media not mounted */
#define STATUS_ARRESTED -4		/* automaticaly put on hold because of a job error */
#define STATUS_CANCEL -5		/* being canceled */
#define STATUS_SEIZING -6		/* going from printing to held */

/*
** Printer status values.
*/
#define PRNSTATUS_IDLE 0		/* idle but ready to print */
#define PRNSTATUS_PRINTING 1		/* printing right now */
#define PRNSTATUS_CANCELING 2		/* canceling a job */
#define PRNSTATUS_SEIZING 3		/* stopping printing current job and holding it */
#define PRNSTATUS_FAULT 4		/* waiting for auto retry */           
#define PRNSTATUS_ENGAGED 5		/* printer is printing for another computer */
#define PRNSTATUS_STARVED 6		/* starved for system resources */
#define PRNSTATUS_STOPT 7		/* stopt by user */
#define PRNSTATUS_STOPPING 8		/* will go to PRNSTATUS_STOPT at job end */
#define PRNSTATUS_HALTING 9		/* pprdrv being killed */
#define PRNSTATUS_DELETED 10		/* printer has been deleted */
#define PRNSTATUS_DELIBERATELY_DOWN 7	/* 1st non-printing value (stopt) */

/*
** "%%ProofMode:" values.
*/
#define PROOFMODE_NOTIFYME -1
#define PROOFMODE_SUBSTITUTE 0		/* default mode */
#define PROOFMODE_TRUSTME 1

/*
** Signiture part values.
*/
#define SIG_FRONTS 1
#define SIG_BACKS 2
#define SIG_BOTH (SIG_FRONTS | SIG_BACKS)

/*
** Flags stored in the unix file permissions of a font:
*/
#define FONT_MACTRUETYPE S_IXUSR	/* Is a Macintosh TrueType font in PostScript form */
#define FONT_TYPE1 S_IXGRP		/* Type 1 components present */
#define FONT_TYPE42 S_IXOTH		/* Type 42 components present */

/*
** Valid TrueType rasterizer settings.
*/
#define TT_UNKNOWN 0
#define TT_NONE 1
#define TT_ACCEPT68K 2
#define TT_TYPE42 3

/*
** Bit values for job and printer status:
*/
#define BIT_JOB_BASE (S_IRUSR | S_IWUSR)
#define BIT_JOB_HELD S_IXUSR
#define BIT_JOB_ARRESTED S_IXGRP

/* end of file */
