/*
** ~ppr/src/include/client.h
** Copyright 1995, Trinity College Computing Center.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Include file for client printer interface.
**
** This file was last modified 23 August 1995.
*/

/* #define DEBUG 1 */

/* file for debug log */
#define CLIENTINT_LOGFILE LOGDIR"/interface_client"

/* device to open for NetBIOS */
#define CIRCUIT "/dev/starlan"

/* program to run to get remote status */
#define REMSTAT "/var/opt/slan/bin/remstat"

#define WORD short int
#define BYTE char

struct clipr_request
	{
	WORD signiture;			/* 0x1988 */
	BYTE clispool_errno;		/* clispool error code */
	BYTE print_errno;		/* spooler return code */
	WORD extra_code;		/* set to -1 if submitted to print */
	BYTE spool_area[40];		/* server name and spool area */
	BYTE drive[2];			/* "x:" */
	BYTE file_name[16];		/* name of file to print */
	} ;

#define SPOOL_AREA_TEMPLATE "\\\\%s.serve\\pprclipr"
#define FILE_NAME_TEMPLATE "JOB%ld"		/* notice upper case! */
#define FULL_FILE_NAME_TEMPLATE "/var/spool/ppr/pprclipr/job%ld"

#define CLISPOOL_OK 0		/* job printed ok */
#define CLISPOOL_STOPPED 1	/* CLISPOOL is disabled */
#define CLISPOOL_CANTLINK 2	/* couldn't link to transfer area */
#define CLISPOOL_DENIED 3	/* this spooler not allowed to connect */
#define CLISPOOL_PRINT_ERROR 4  /* print wouldn't accept the job */

/* end of file */
