/*
** ~ppr/src/fakers/fake_lp.c
** Copyright 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
**
** Last modified 30 January 1997.
*/

#include "global_defines.h"
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <unistd.h>

#define FULL_PPR_PATH HOMEDIR"/"PPR_PATH

const char *option_list = "cd:f:H:mn:o:P:pq:t:T:rwy:";

void run(const char *file, const char *const argv[])
    {
    pid_t pid;
    int wstatus;

    if( (pid = fork()) == -1 )
	{
    	fprintf(stderr, "fake_lp: fork() failed, errno=%d (%s)\n", errno, strerror(errno));
	exit(1);
	}
    else if( pid == 0 )
    	{
	execv(file, (char *const *)argv); /* it's OK, execv() won't modify it */
	fprintf(stderr, "fake_lp: execv() of \"%s\" failed, errno=%d (%s)\n", file, errno, strerror(errno));
	exit(242);
	}
    else
	{
    	if(wait(&wstatus) == -1)
    	    {
    	    fprintf(stderr, "fake_lp: wait() failed, errno=%d (%s)\n", errno, strerror(errno) );
	    exit(1);
    	    }
	else
	    {
	    if(! WIFEXITED(wstatus))
	    	{
		if(WCOREDUMP(wstatus))
		    fprintf(stderr, "fake_lp: %s: core dumped\n", argv[0]);
		else
		    fprintf(stderr, "fake_lp: %s: Killed\n", argv[0]);
		exit(1);
	    	}
	    if(WEXITSTATUS(wstatus))
		{
		if(WEXITSTATUS(wstatus) != 242)
		    fprintf(stderr, "fake_lp: %s: failed, exit code = %d\n", argv[0], WEXITSTATUS(wstatus));
		exit(1);
		}
	    }
	}
    } /* end of run() */

int main(int argc, char *argv[])
    {
    int c;
    extern char *optarg;
    extern int optind;
    const char *ppr_argv[100];
    int i;

    /*========================================================
    ** Step 1, we gather information from the command line.
    ========================================================*/
    char *opt_id = (char*)NULL;
    char *opt_dest = (char*)NULL;
    char *opt_form = (char*)NULL;
    char *opt_handling = (char*)NULL;
    int opt_send_mail = FALSE;
    int opt_copies = -1;
    int opt_notification = FALSE;
    int opt_priority = -1;
    int opt_suppress_messages = FALSE;
    char *opt_charset = (char*)NULL;
    char *opt_title = (char*)NULL;
    char *opt_content_type = (char*)NULL;
    int opt_write_message = FALSE;
    char *opt_mode_list = (char*)NULL;
    
    while( (c=getopt(argc, argv, option_list)) != -1 )
	{
	switch(c)
	    {
	    case 'i':		/* request id */
	    	opt_id = optarg;
	    	break;
	    case 'c':		/* copy immediately -- PPR does this anyway */
	    	break;
	    case 'd':		/* destination */
		opt_dest = optarg;
	    	break;
	    case 'f':		/* form name */
		opt_form = optarg;
		break;
	    case 'H':		/* special handling */
	    	opt_handling = optarg;
	    	break;
	    case 'm':		/* send mail on normal completion */
	    	opt_send_mail = TRUE;
	    	break;
	    case 'n':		/* number of copies */
	    	opt_copies = atoi(optarg);
	    	break;
	    case 'o':		/* printer options */
	        break;
	    case 'P':		/* page list */
	    	break;
	    case 'p':		/* enable notification */
	    	opt_notification = TRUE;
	    	break;
	    case 'q':		/* queue priority */
	    	opt_priority = atoi(optarg);
	    	break;
	    case 's':		/* suppress messages */
		opt_suppress_messages = TRUE;
	    	break;
	    case 'S':		/* character set */
		opt_charset = optarg;
	    	break;
	    case 't':		/* title */
	    	opt_title = optarg;
	    	break;
	    case 'T':		/* content type */
	    	opt_content_type = optarg;
	    	break;
	    case 'r':		/* content type raw */
	    	opt_content_type = "raw";
	    	break;
	    case 'w':		/* write a message at job completion */
	    	opt_write_message = TRUE;
	    	break;
	    case 'y':		/* mode list */
	    	opt_mode_list = optarg;
	    	break;
	    default:
		fprintf(stderr, "Error!\n");
		return 1;	    
	    }
	} 

    /*========================================================
    ** Step 2, if we are not being asked to accept a file, we do something else
    ** and then skip steps 3 and 4.
    ========================================================*/
    

    /*========================================================
    ** Step 3, we build the argv[] array.
    ========================================================*/
    i = 0;
    ppr_argv[i++] = "ppr";

    /* The destionation */
    if(opt_dest == (char*)NULL)
	if( (opt_dest = getenv("LPDEST")) == (char*)NULL )
	    opt_dest = getenv("PRINTER");
    if(opt_dest != (char*)NULL)
	{
	ppr_argv[i++] = "-d";
	ppr_argv[i++] = opt_dest;
	}

    /* How shall the user be notified? */
    if(opt_send_mail)
    	{
    	ppr_argv[i++] = "-m";
    	ppr_argv[i++] = "mail";
    	}
    else if(! opt_write_message)
    	{
    	ppr_argv[i++] = "-m";
    	ppr_argv[i++] = "errmail";
    	}

    /* lp normaly shows the request id */
    if(! opt_suppress_messages)
    	ppr_argv[i++] = "--show-id";


    /*========================================================
    ** Step 4, we print the files.
    ========================================================*/
    if(optind == argc)
    	{
	ppr_argv[i] = (char*)NULL;
	run(FULL_PPR_PATH, ppr_argv);
    	}
    else
	{
	for(; optind < argc; optind++)
	    {
	    ppr_argv[i] = argv[optind];
	    ppr_argv[i+1] = (char*)NULL;
		
	    run(FULL_PPR_PATH, ppr_argv);
	    }
	}

    return 0;
    } /* end of main() */

/* end of file */
