#!/bin/sh
#
# ~ppr/src/commentators/xwin.sh
# Copyright 1995, 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
# 
# This file was last modified 8 November 1996.
#

# The place where the X-Windows binaries are kept.
XWINBINDIR="/usr/bin/X11"

# Give the perameters names.
address="$1"
options="$2"
printer="$3"
code="$4"
cooked="$5"
raw1="$6"
raw2="$7"

# Handle the fact that we may not have a cooked message
# for certain printer errors.  (Actually, for any printer 
# errors in the current version of PPR.)
if [ -z "$cooked" ]; then cooked="$raw1"; fi

if [ -x /usr/bin/X11/xmessage ]
    then
    /bin/echo "$printer: $cooked\n" \
	| /usr/bin/X11/xmessage -display $address \
		-geometry +100+100 \
		-title "Operator message concerning \"$printer\" (`uname -n`)." \
		-bg pink -fg black \
		-default okay -timeout 60 \
		-file - &
    else
    /usr/bin/X11/xterm -display "$address" \
	-geometry 80x5+100+100 \
	-title "Operator message concerning \"$printer\" (`uname -n`)." \
	-bg pink -fg black \
	-e /bin/sh -c "echo \"$printer: $cooked\";
		echo ;
		echo 'Please press RETURN to clear this message.';
		read x" &
    fi

exit 0
