#!/bin/sh
#
# ~ppr/src/commentators/samba.sh
# Copyright 1995, 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 18 March 1997.
#

# 
# This commentator sends to the operator by means of Samba's smbclient.  In 
# order for this script to work, each host must have a DNS name in 
# the form "NETBIOSNAME.pc".
#

address="$1"
options="$2"
printer="$3"
code="$4"
cooked="$5"
raw1="$6"
raw2="$7"

# Handle the fact that we may not have a cooked message
# for certain printer errors.  (Actually, for any printer 
# errors in the current version of PPR.)
if [ -z "$cooked"]; then cooked="$raw1"; fi

# Break up the address:
NBNAME=`echo $address | cut -d'-' -f1`
IP=`echo $address | cut -d'-' -f2`
if [ -n "$IP" ]; then IP="-I $IP"; fi

/bin/echo "$printer: $cooked\n\nPlease press Control-D to remove this message" \
	| /usr/local/samba/bin/smbclient -U ppr -M $NBNAME $IP \
		>/dev/null 2>&1

exit 0
