/*  Program: Printing PNM graphics format on a NEC P6
 *  Author:  Helmut Riegler
 *  EMail:   helmut.riegler@fast.co.at
 */


#include <stdio.h>
#include <unistd.h>

#include "printers.h"

extern int optind;
extern char *optarg;

#ifdef __STDC__
static void exit_usage(char *s)
#else
static void exit_usage(s)
char *s;
#endif
{
  Driver_List *driver;

  fprintf(stderr, "usage: %s -d driver [-o opt] [-h] [PNM - file]\n", s);
  fprintf(stderr, "       -h .. help\n");

  for(driver = driver_list; driver->driver_name; driver++) {
    (*driver->driver)(NULL, NULL, 0, &driver->driver_name);
  }

  exit(0);
}

#ifdef __STDC__
main(int argc, char *argv[])
#else
main(argc, argv)
int argc;
char *argv[];
#endif

{
  FILE *fd;
  int opt;
  char *driver_name = NULL;
  Driver_List *driver;
  int rc;

  /* reading arguments */
  while((opt = getopt(argc, argv, "hd:o:")) != -1)
    switch(opt) {
    case 'h':
      exit_usage(argv[0]);

    case 'd':
      driver_name = optarg;
      break;

    case 'o':
      break;

    default:
      fprintf(stderr, "%s: error in getopt\n", argv[0]);
      exit_usage(argv[0]);
    }

  /* if no remaining arguments -> using stdin */
  if(optind == argc) {
    fd = stdin;
  } else {
    if(!(fd = fopen(argv[optind], "r"))) {
      fprintf(stderr, "%s: can't open '%s'\n", argv[0], argv[optind]);
      exit(2);
    }
  }

  /* warning when too much arguments */
  if(argc - optind > 1)
    fprintf(stderr, "%s: Warning, arguments ignored\n", argv[0]);

  /* a driver must be specified */
  if(!driver_name) {
    fprintf(stderr, "%s: no driver specified\n", argv[0]);
    exit_usage(argv[0]);
  }

  /* searching the driver */
  for(driver = driver_list;
      driver->driver_name && strcmp(driver_name, driver->driver_name);
      driver++);

  /* calling the driver */
  if(driver->driver_name) {
    if(rc = (*driver->driver)(fd, stdout, argc, argv)) {
      fprintf(stderr, "%s: error calling driver: '%s'\n",
	      argv[0], driver_name);
      exit(rc);
    }
  } else {
   fprintf(stderr, "%s: no such driver: '%s'\n", argv[0], driver_name);
   exit(3);
  }

  /* closing input file */
  if(fd != stdin)
    fclose(fd);

  exit(0);
}
