#include <stdio.h>
#include "pnmread.h"


static Pnm_Info pnm_info;

#ifdef __STDC__
static int ppm_get_pixel_mono_binary(int *pixel, FILE *fd)
#else
static int ppm_get_pixel_mono_binary(pixel, fd)
int *pixel;
FILE *fd;
#endif
{
  char red, green, blue;

  if(pixel) {
    fread(&red, 1, 1, fd);
    fread(&green, 1, 1, fd);
    fread(&blue, 1, 1, fd);

    *pixel = (red != (char)pnm_info.colors) ||
      (green != (char)pnm_info.colors) ||
      (blue != (char)pnm_info.colors);;
  }

  return(0);
}

#ifdef __STDC__
static int ppm_get_pixel_mono_ascii(int *pixel, FILE *fd)
#else
static int ppm_get_pixel_mono_ascii(pixel, fd)
int *pixel;
FILE *fd;
#endif
{
  int z;
  long red, green, blue;
  int state;

  state = 0;
  if(pixel) {
    while(1) {
      switch(z = fgetc(fd)) {

	/* ignore whitespaces */
      case ' ':
      case '\t':
      case '\n':
      case '\r':
	break;

	/* ignoring lines with # */
      case '#':
	while((z = fgetc(fd)) != '\n' && z != EOF);
	break;

      default:
	switch(state) {
	case 0:
	  ungetc(z, fd);
	  fscanf(fd, "%ld", &red);
	  state++;
	  break;
	case 1:
	  ungetc(z, fd);
	  fscanf(fd, "%ld", &green);
	  state++;
	  break;
	case 2:
	  ungetc(z, fd);
	  fscanf(fd, "%ld", &blue);
	  *pixel = (red != pnm_info.colors) ||
	    (green != pnm_info.colors) ||
	    (blue != pnm_info.colors);;
	  return(0);
	  break;
	}
	break;

      case EOF:
	return(1);
      }
    }
  }

  return(0);
}

#ifdef __STDC__
static int pgm_get_pixel_mono_binary(int *pixel, FILE *fd)
#else
static int pgm_get_pixel_mono_binary(pixel, fd)
int *pixel;
FILE *fd;
#endif
{
  char c;

  if(pixel) {
    fread(&c, 1, 1, fd);

    *pixel = (c != (char)pnm_info.colors);
  }

  return(0);
}

#ifdef __STDC__
static int pgm_get_pixel_mono_ascii(int *pixel, FILE *fd)
#else
static int pgm_get_pixel_mono_ascii(pixel, fd)
int *pixel;
FILE *fd;
#endif
{
  int z;
  long lz;

  if(pixel) {
    while(1) {
      switch(z = fgetc(fd)) {

	/* ignore whitespaces */
      case ' ':
      case '\t':
      case '\n':
      case '\r':
	break;

	/* ignoring lines with # */
      case '#':
	while((z = fgetc(fd)) != '\n' && z != EOF);
	break;

      default:
	ungetc(z, fd);
	fscanf(fd, "%ld", &lz);
	*pixel = (lz != pnm_info.colors);
	return(0);

      case EOF:
	return(1);
      }
    }
  }

  return(0);
}

#ifdef __STDC__
static int pbm_get_pixel_mono_binary(int *pixel, FILE *fd)
#else
static int pbm_get_pixel_mono_binary(pixel, fd)
int *pixel;
FILE *fd;
#endif
{
  static int bit = 8;
  static char c;

  /* for masking the right bit */
  static char bit_value[8] = {
    128,
    64,
    32,
    16,
    8,
    4,
    2,
    1
  };

  if(pixel) {
    if(bit > 7) {
      bit = 0;
      fread(&c, 1, 1, fd);
    }

    *pixel = c & bit_value[bit++];
  } else {
    /* end of scan line */
    if(bit) {
      bit = 8;
    }
  }

  return(0);
}

#ifdef __STDC__
static int pbm_get_pixel_mono_ascii(int *pixel, FILE *fd)
#else
static int pbm_get_pixel_mono_ascii(pixel, fd)
int *pixel;
FILE *fd;
#endif
{
  int z;

  if(pixel) {
    while(1) {
      switch(fgetc(fd)) {

	/* ignore whitespaces */
      case ' ':
      case '\t':
      case '\n':
      case '\r':
	break;

	/* ignoring lines with # */
      case '#':
	while((z = fgetc(fd)) != '\n' && z != EOF);
	break;

      case '1':
	*pixel = 1;
	return(0);

      case '0':
	*pixel = 0;
	return(0);

      default:
	return(1);
      }
    }
  }
}

#ifdef __STDC__
static int ppm_get_pixel_color_binary(int *pixel_yellow, int *pixel_red,
				      int *pixel_blue, int *pixel_black,
				      FILE *fd)
#else
static int ppm_get_pixel_color_binary(pixel_yellow, pixel_red,
				      pixel_blue, pixel_black,
				      fd)
int *pixel_yellow;
int *pixel_red;
int *pixel_blue;
int *pixel_black;
FILE *fd;
#endif
{
  char red, green, blue;

  if(pixel_yellow) {

    fread(&red, 1, 1, fd);
    fread(&green, 1, 1, fd);
    fread(&blue, 1, 1, fd);

    *pixel_black  = 0;
    *pixel_red    = (green != (char)pnm_info.colors);
    *pixel_blue   = (red   != (char)pnm_info.colors);
    *pixel_yellow = (blue  != (char)pnm_info.colors);

    if(*pixel_red && *pixel_blue && *pixel_yellow) {
      *pixel_black = 1;
      *pixel_yellow = *pixel_red = *pixel_blue = 0;
    }
  }

  return(0);
}

#ifdef __STDC__
static int ppm_get_pixel_color_ascii(int *pixel_yellow, int *pixel_red,
				     int *pixel_blue, int *pixel_black,
				     FILE *fd)
#else
static int ppm_get_pixel_color_ascii(pixel_yellow, pixel_red,
				     pixel_blue, pixel_black,
				     fd)
int *pixel_yellow;
int *pixel_red;
int *pixel_blue;
int *pixel_black;
FILE *fd;
#endif
{
  int z;
  long red, green, blue;
  int state;

  state = 0;
  if(pixel_yellow) {
    while(1) {
      switch(z = fgetc(fd)) {

	/* ignore whitespaces */
      case ' ':
      case '\t':
      case '\n':
      case '\r':
	break;

	/* ignoring lines with # */
      case '#':
	while((z = fgetc(fd)) != '\n' && z != EOF);
	break;

      default:
	switch(state) {
	case 0:
	  ungetc(z, fd);
	  fscanf(fd, "%ld", &red);
	  state++;
	  break;
	case 1:
	  ungetc(z, fd);
	  fscanf(fd, "%ld", &green);
	  state++;
	  break;
	case 2:
	  ungetc(z, fd);
	  fscanf(fd, "%ld", &blue);

	  *pixel_black  = 0;
	  *pixel_red    = (green != (char)pnm_info.colors);
	  *pixel_blue   = (red   != (char)pnm_info.colors);
	  *pixel_yellow = (blue  != (char)pnm_info.colors);

	  if(*pixel_red && *pixel_blue && *pixel_yellow) {
	    *pixel_black = 1;
	    *pixel_yellow = *pixel_red = *pixel_blue = 0;
	  }

	  return(0);
	  break;
	}
	break;

      case EOF:
	return(1);
      }
    }
  }

  return(0);
}

#ifdef __STDC__
static int pgm_get_pixel_color_binary(int *pixel_yellow, int *pixel_red,
				      int *pixel_blue, int *pixel_black,
				      FILE *fd)
#else
static int pgm_get_pixel_color_binary(pixel_yellow, pixel_red,
				      pixel_blue, pixel_black,
				      fd)
int *pixel_yellow;
int *pixel_red;
int *pixel_blue;
int *pixel_black;
FILE *fd;
#endif
{
  char c;

  if(pixel_yellow) {
    fread(&c, 1, 1, fd);

    *pixel_yellow = *pixel_red = *pixel_blue = 0;
    *pixel_black = (c != (char)pnm_info.colors);
  }

  return(0);
}

#ifdef __STDC__
static int pgm_get_pixel_color_ascii(int *pixel_yellow, int *pixel_red,
				     int *pixel_blue, int *pixel_black,
				     FILE *fd)
#else
static int pgm_get_pixel_color_ascii(pixel_yellow, pixel_red,
				     pixel_blue, pixel_black,
				     fd)
int *pixel_yellow;
int *pixel_red;
int *pixel_blue;
int *pixel_black;
FILE *fd;
#endif
{
  int z;
  long lz;

  if(pixel_yellow) {
    while(1) {
      switch(z = fgetc(fd)) {

	/* ignore whitespaces */
      case ' ':
      case '\t':
      case '\n':
      case '\r':
	break;

	/* ignoring lines with # */
      case '#':
	while((z = fgetc(fd)) != '\n' && z != EOF);
	break;

      default:
	ungetc(z, fd);
	fscanf(fd, "%ld", &lz);

	*pixel_yellow = *pixel_red = *pixel_blue = 0;

	*pixel_black = (lz != pnm_info.colors);
	return(0);

      case EOF:
	return(1);
      }
    }
  }

  return(0);
}

#ifdef __STDC__
static int pbm_get_pixel_color_binary(int *pixel_yellow, int *pixel_red,
				      int *pixel_blue, int *pixel_black,
				      FILE *fd)
#else
static int pbm_get_pixel_color_binary(pixel_yellow, pixel_red,
				      pixel_blue, pixel_black,
				      fd)
int *pixel_yellow;
int *pixel_red;
int *pixel_blue;
int *pixel_black;
FILE *fd;
#endif
{
  static int bit = 8;
  static char c;

  /* for masking the right bit */
  static char bit_value[8] = {
    128,
    64,
    32,
    16,
    8,
    4,
    2,
    1
  };

  if(pixel_yellow) {
    if(bit > 7) {
      bit = 0;
      fread(&c, 1, 1, fd);
    }

    *pixel_yellow = *pixel_red = *pixel_blue = 0;

    *pixel_black = c & bit_value[bit++];

  } else {
    /* end of scan line */
    if(bit) {
      bit = 8;
    }
  }

  return(0);
}

#ifdef __STDC__
static int pbm_get_pixel_color_ascii(int *pixel_yellow, int *pixel_red,
				     int *pixel_blue, int *pixel_black,
				     FILE *fd)
#else
static int pbm_get_pixel_color_ascii(pixel_yellow, pixel_red,
				     pixel_blue, pixel_black,
				     fd)
int *pixel_yellow;
int *pixel_red;
int *pixel_blue;
int *pixel_black;
FILE *fd;
#endif
{
  int z;

  if(pixel_yellow) {

    *pixel_yellow = *pixel_red = *pixel_blue = 0;

    while(1) {
      switch(fgetc(fd)) {

	/* ignore whitespaces */
      case ' ':
      case '\t':
      case '\n':
      case '\r':
	break;

	/* ignoring lines with # */
      case '#':
	while((z = fgetc(fd)) != '\n' && z != EOF);
	break;

      case '1':
	*pixel_black = 1;
	return(0);

      case '0':

	*pixel_black = 0;
	return(0);

      default:
	return(1);
      }
    }
  }
}

#ifdef __STDC__
Pnm_Info *pnm_get_info(FILE *fd)
#else
Pnm_Info *pnm_get_info(fd)
FILE *fd;
#endif
{
  int loop;
  int c;
  int state;

  loop = 1;
  state = 0;

  /* reading pnm file */
  while(loop) {
    switch(c = fgetc(fd)) {

      /* ignore whitespaces */
    case ' ':
    case '\t':
    case '\n':
    case '\r':
      break;

      /* ignoring lines with # */
    case '#':
      while((c = fgetc(fd)) != '\n' && c != EOF);
      break;

      /* EOF -> error */
    case EOF:
      return(NULL);

    default:
      ungetc(c, fd);

      /* reading header info */
      switch(state) {
      case 0:
	fscanf(fd, "%2s", pnm_info.magic);
	state++;

	if(pnm_info.magic[0] != 'P')
	  return(NULL);

	switch(pnm_info.magic[1]) {

	case '1':
	  pnm_info.binary = 0;
	  pnm_info.type = PBM;
	  pnm_info.get_pixel_mono  = pbm_get_pixel_mono_ascii;
	  pnm_info.get_pixel_color = pbm_get_pixel_color_ascii;
	  break;

	case '2':
	  pnm_info.binary = 0;
	  pnm_info.type = PGM;
	  pnm_info.get_pixel_mono  = pgm_get_pixel_mono_ascii;
	  pnm_info.get_pixel_color = pgm_get_pixel_color_ascii;
	  break;

	case '3':
	  pnm_info.binary = 0;
	  pnm_info.type = PPM;
	  pnm_info.get_pixel_mono  = ppm_get_pixel_mono_ascii;
	  pnm_info.get_pixel_color = ppm_get_pixel_color_ascii;
	  break;

	case '4':
	  pnm_info.binary = 1;
	  pnm_info.type = PBM;
	  pnm_info.get_pixel_mono  = pbm_get_pixel_mono_binary;
	  pnm_info.get_pixel_color = pbm_get_pixel_color_binary;
	  break;

	case '5':
	  pnm_info.binary = 1;
	  pnm_info.type = PGM;
	  pnm_info.get_pixel_mono  = pgm_get_pixel_mono_binary;
	  pnm_info.get_pixel_color = pgm_get_pixel_color_binary;
	  break;

	case '6':
	  pnm_info.binary = 1;
	  pnm_info.type = PPM;
	  pnm_info.get_pixel_mono  = ppm_get_pixel_mono_binary;
	  pnm_info.get_pixel_color = ppm_get_pixel_color_binary;
	  break;

	default:
	  return(NULL);
	}

	break;

      case 1:
	fscanf(fd, "%ld", &pnm_info.width);
	state++;
	break;

      case 2:
	fscanf(fd, "%ld", &pnm_info.height);
	state++;

	if(pnm_info.type == PBM)
	  state++;

	break;

      case 3:
	fscanf(fd, "%ld", &pnm_info.colors);
	state++;
	break;

      case 4:
	loop = 0;
	break;
      }

      break;
    }
  }

  return(&pnm_info);
}
