#! /bin/bash
##############################
# test.sh - testing 
#
# by M. Andreoli (1997) 
# personal use only
##############################

PATH=/bin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin


# 
. global.config
. ${DEFAULT_PRINTER}

txt=./Makefile
> ${SPOOLDIR}/log 

#set -x

test_start()
{
echo ""
echo -en "Testing [$1]->[$2] conversion ..."
rm /tmp/$2 2>/dev/null
}

test_if_exist()
{
lpq| head -1
while lpq | grep -v "no entries" 2>&1 > /dev/null
do
:
done

if [ -r /tmp/$1.test ]
then
	echo -e "  Found [`file /tmp/$1.test| cut -d: -f2` ]"
else
	echo -ne "Failed (see log file)"
fi
}


echo
echo "TEST one-step CONVERSION CAPABILITIES "
echo "--------------------------------------"
echo

test_start txt g3
lpr -C"device=g3;output=>/tmp/g3.test" ${txt}
test_if_exist g3

test_start txt ps 
lpr -C"device=ps;output=>/tmp/ps.test" ${txt}
test_if_exist ps 

test_start txt tiffg3 
lpr -C"device=tiffg3;output=>/tmp/tiffg3.test" ${txt}
test_if_exist tiffg3 

test_start g3 ps
lpr -C"device=g3;output=>/tmp/g3.test" ${txt} 
test_if_exist g3
lpr -C"device=ps;output=>/tmp/ps.test" /tmp/g3.test 
test_if_exist ps


test_start txt hp-pcl 
lpr -C"device=gs_laserjet;output=>/tmp/hp-pcl.test" ${txt}
test_if_exist hp-pcl

test_start txt ps_mpage 
lpr -C"device=ps_mpage;sheet=2; pages=1-2; output=>/tmp/ps_mpage.test" ${txt}
test_if_exist ps_mpage

test_start jpg ps
lpr -C"device=ps; scale=3; output=>/tmp/jpg.test" files/*.jpg 
test_if_exist jpg 

test_start gif ps
lpr -C"device=ps; scale=3; output=>/tmp/gif.test" files/*.gif
test_if_exist gif 

test_start tex ps
lpr -C"device=ps; output=>/tmp/tex.test" files/*.tex
test_if_exist tex 

test_start html txt 
lpr -C"device=txt; output=>/tmp/html.test" files/*.html
test_if_exist html 




echo
echo "TESTING audio files "
echo "--------------------------------------"
echo


test_start au audio 
lpr -#2 ./files/*.au 

test_start wav audio
lpr -#2 ./files/*.wav

test_start mid audio
lpr  ./files/*.mid

sleep 2

echo
echo
echo "TESTING mail & tcp "
echo "--------------------------------------"
echo

echo "Hello, world!" | lpr -C"device=mail; \
subject="lprMagic-Mail-Test"; from=lprMagic; to=`logname`"
echo ls | lpr -C"device=ftp; host=localhost"

echo
echo "ftp test ...See your mbox."
echo
echo
echo "TESTING delayed processing "
echo "--------------------------------------"
echo

echo
echo "Sending mail ...See your mbox."

echo "Hello, world! at `date`" | lpr -C"device=mail; \
subject=lprMagic-Mail-Delayed-Test; \
from=lprMagic; to=`logname`; at=now + 3 minutes"


echo
echo -n "Do you want test, of course, also the REAL printer? (y/n)>"
read answer

if [ "${answer}" = "y" ]
then
echo
echo "TESTING (real) printer "
echo "--------------------------------------"
echo

test_start troff ${DEFAULT_PRINTER} 
man -t ps | lpr -C"sheet=4; pages=1-4"
echo "Printing ..."

fi

echo

rm /tmp/*.test
lpq

echo
echo "This is the lpd log-file:"
echo
sleep 2

echo
echo "See the log file : ${SPOOLDIR}/log for errors report."
