/* 
lprMagic/pathfinder.c, 

Find the filter-path [from]->[to]

*/

/*
 * Copyright (C) 1997
 *      Michele Andreoli, Pontedera (PISA) Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <string.h>
#include "version.h"


#define MAX 256 
#define LINE 2048 
#define USAGE "\nUsage: %s [-v] config_file [-l] [from] [to]\n"

char *(inf[MAX]),*(outf[MAX]),*(cmd[MAX]),line[LINE];
int checked[MAX,MAX];
static char *ERROR="NOT_FOUND";
static char *IDENTITY=" ";
static char* CONFIG_FILE="/etc/lprMagic.conf";
static char PROGNAME[64];


int n;


int compare(char *p, char *q)
{
int i;

i=0;
while ( (p[i]!='\0')&&(q[i]!='\0')&&(p[i]==q[i]) ) i++;

if ( (p[i]=='\0') && (q[i]=='\0')) return 0;
if ( (p[i]=='*') || (q[i]=='*')) return 0;

return 1;
}



read_conf()
{
int i,j,offset,mem;
FILE *fdconf;
char ib[LINE],ob[LINE],cb[LINE];

if ( ( fdconf=fopen(CONFIG_FILE,"r") ) < 0 )
{
        fprintf(stderr,"%s: File %s non-existent!\n",PROGNAME,CONFIG_FILE);
        exit(1);
}

offset=0;
for ( ;fscanf(fdconf,"%[^\n]%*\n",line+offset ) != EOF;)
{

offset=strlen(line);

if (line[offset-1]=='\\') {  offset-=1;continue;}
offset=0;

if (   line[0]=='#' )  continue;

if (sscanf(line,"%*[ \t]\n") != 0 ) continue ;

ob[0]='\0'; ib[0]='\0'; cb[0]='\0';

	sscanf(line,"%[^:]%*[ \t:]%[^:]%*[ \t:]%[^\n]%*\n",ob,ib,cb) ;
	n++;
	mem=strlen(line);
	inf[n]=(char*) malloc(mem);
	outf[n]=(char*) malloc(mem);
	cmd[n]=(char*) malloc(mem);
	strcpy(inf[n],ib);	
	strcpy(outf[n],ob);	
	strcpy(cmd[n],cb);	
}

/* Reset checked[] */

for (i=1; i<=n;i++)
	for (j=1;j<=n;j++) checked[i,j]=0;

}

/* Tab position */

int pos( char *s, char **tab )
{
int i;
	for (i=1; i<=n ; i++)
	{
	if (  compare(tab[i],s) == 0 ) return i;
	}
return 0;
} 

/* Main recursive routine */

char* Filter(char *O,char *I)
{
char *r,*f;
int px,py,pi,po;
int i;

/* return identity */

if ( compare(O,I)==0 ) return IDENTITY;

/* single step filter */

for(i=1;i<=n;i++)
{
if ( compare(O,outf[i])==0 && compare(I,inf[i])==0 ) 
			return cmd[i] ;
}

/* But, are these format known? */

pi=pos(I,inf);
po=pos(O,outf);

if ( ! pi || ! po  ) 
	return ERROR;

/* have you ever been here? */

if (checked[pi,po] ) return ERROR;


r=(char*) malloc(2*LINE);

/* multiple-step searching */

for (py=1;py<=n; py++)
{
if ( compare(outf[py],O) != 0 ) continue;

	/* backtracking */
	f=Filter(inf[py],I);
	
	if (strcmp(f,ERROR)!=0 )
		{
		sprintf(r,"%s %s",f,cmd[py]);
		return r;
		}
	else { checked[pi,po]++; }
}

return ERROR;
}

main(int argc, char** argv)
{
char *From=NULL,*To=NULL,*option=NULL;
int i,p=1;

/* Parsing */


sprintf(PROGNAME,"%s (Ver. %s)",argv[0],VERSION);

switch (argc)
{
case 1: 
case 2: {fprintf(stderr,USAGE,PROGNAME) ;exit(1);}
case 3: CONFIG_FILE=argv[1]; option=argv[2]; break; 
case 4: CONFIG_FILE=argv[1]; From=argv[2]; To=argv[3];break; 
default: {fprintf(stderr,USAGE,PROGNAME) ;exit(1);}
}


/* read conf. file */

read_conf();


if (option && option[0]=='-' ) 
{

switch(option[1])
{
case 'v': fprintf(stderr,"by M.Andreoli, (C) 1997, Ver %s\n",VERSION); break;
case 'l': 
	fprintf(stderr,"Total # of production rules: %i\n",n);
	fprintf(stderr,"\nFilter table (from %s)\n--------------\n",CONFIG_FILE);
	for (i=1;i<=n; i++) 
	{
	fprintf(stderr,"[%s] -> [%s] WITH [ %s ]\n",inf[i],outf[i],cmd[i]);
	}
	break;
default: fprintf(stderr,"Unknown option :%s\n",option); 
}
exit(0);
}


printf("%s",Filter(To,From)); 


}
