#! /bin/bash
##############################
# need.sh - test installed pkg 
#
# by M. Andreoli (1997) 
# personal use only
##############################

PATH=/bin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin

#set -x



/usr/local/bin/pathfinder /etc/lprMagic.conf -l 2> conf 

# Tools list

TOOLS="gs \
djpeg giftopnm  bmptoppm pnmtops g32pbm  \
dvips groff \
efax \
playmidi vplay timidity s3mod \
ftp smbclient sendmail nc lynx"

echo
echo "CHECKING CONVERSION TOOLS INSTALLED on YOUR SYSTEM"
echo "--------------------------------------------------"
echo


emergency_install()
{

case $1 in
a2ps) 
	echo -n "Do you want an emergency installation of ${t} package? (y/n)"
	read answer
	case ${answer} in
	y|Y)  
	
	echo "Emergency Installation of ${t} package ..."
	cat bin/${t}.gz| gzip -d > /usr/local/bin/${t}
	chmod +x /usr/local/bin/${t}
	tar -C"/" -zxf bin/${t}.tar.gz
	;;
	esac
;;
esac
}

# Chech if installed

find_conv()
{
grep ".*WITH.*${1}" conf|\
sed 's/\(.*\)WITH.*/\1/g'|\
sed 's/\n/\&/g'| head -1
}



for t in ${TOOLS}
do


if which ${t} &>/dev/null
then
	echo -e "${t}      \tfound,\t\t an option for `find_conv ${t}`"
else
	echo -e "${t}      \tnot found,\t an option for `find_conv ${t}`"
	emergency_install ${t} 
fi

done

rm conf
