#! /bin/bash
# install.sh - install lprMagic Universal Filter 
# by M. Andreoli (1997)

#set -x
PATH=/bin:/usr/bin:/usr/sbin:/sbin:/usr/local/bin:


# TUNE THIS!

OWNER=lp


install_mpage()
{
cd mpage-2.5
make clean
make
make install
cd ..
}


writable()
{
res=`su $OWNER -c "[ -w $1 ] && echo si"`
echo $res
}

# 
# read  Global config Parameter
#
. global.config

OLDCAP=/etc/printcap.old
NEWCAP=/etc/printcap

clear
echo
echo "lprMagic INSTALLATION TOOL"
echo "by M. Andreoli, (C) 1997"
echo "--------------------------"


#
# 1st save printcap
#
if [ ! -f /etc/printcap.orig ]
then
    echo "... copying original printcap to /etc/printcap.orig"
    cp /etc/printcap /etc/printcap.orig
    sleep 1
else
    echo "Good, you already saved your original printcap to /etc/printcap.orig"
    echo
    echo "... copying /etc/printcap to /etc/printcap.old"
    cp /etc/printcap $OLDCAP
    sleep 1
fi


#
# repl
#


	echo
	echo "REPLACE VERSION SYMBOL"
	echo
	sleep 1

        eval sed \'s/VERSION/${VERSION}/g\' < lprMagic.conf.in > lprMagic.conf
        eval sed \'s/VERSION/${VERSION}/g\' < unifilter.in > unifilter
        eval sed \'s/VERSION/${VERSION}/g\' < lprMagic.1.in > lprMagic.1
        chmod +x unifilter

#
# 1st save lprMagic.conf
#

if [  -f /etc/lprMagic.conf ]
then
    echo "... copying original lprMagic.conf to /etc/lprMagic.conf.old"
    cp /etc/lprMagic.conf /etc/lprMagic.conf.old
    sleep 1
fi

# /etc/lprMagic.conf

echo  "... setting up /etc/lprMagic.conf ..."
cp -p lprMagic.conf /etc



#
# /etc/printcap head
#

echo "# ** lprMagic Universal Filter Printcap Setting (V${VERSION}) **" > $NEWCAP 
echo "# ** by M. Andreoli **" >> $NEWCAP 


echo
echo "PRINTER'S SETTINGS"
echo
sleep 1

# Printer list 

printer_list=${DEFAULT_PRINTER}

if [ -z ${DEFAULT_PRINTER} ]
then
	echo 
	echo "Warning:  DEFAULT_PRINTER is non set"
	echo
printer_list="`/bin/ls printer.*`"
else
printer_list="${printer_list} `/bin/ls printer.* | grep -v ${DEFAULT_PRINTER}`"
fi

for printer_file in ${printer_list} 
do
echo "... setting up ${printer_file} ..."


. ${printer_file}


# Create spooldir & file

mkdir -p $SPOOLDIR  &>/dev/null

: > $SPOOLDIR/log
: > "$SPOOLDIR/acct-${ENCODED}"
: > $SPOOLDIR/lock

mkdir -m 777 -p $SPOOLDIR/atspool &> /dev/null

# Set permission & copy printer.file

case ${SPOOLER_SYSTEM} in
BSD)

chown -R root.lp $SPOOLDIR
chmod ug+w ${SPOOLDIR}
chmod +r ${SPOOLDIR}/lock
chown  bin.bin $SPOOLDIR/atspool
;;
lprng)

chown -R lp.lp $SPOOLDIR
chmod ug+w ${SPOOLDIR}
chmod +r ${SPOOLDIR}/lock
#chown lp.lp ${SPOOLDIR}/log
chown  bin.bin $SPOOLDIR/atspool

cp -p ${printer_file} ${SPOOLDIR}

;;
esac



#
#  /etc/printcap body
#

label="${LABEL} Printer Setup (with lprMagic-${VERSION}):"

echo >> $NEWCAP
echo "# ${label}" >> $NEWCAP
echo >> $NEWCAP

if [ ${DEFAULT_PRINTER} = ${printer_file} ]
then
	prefix="lp|"
else
	prefix=
fi

if [ ${SPOOLER_SYSTEM} = "lprng" ]
then
	ER=""
else
	ER=":\\"
fi

echo "${prefix}${LABEL}$ER" >> $NEWCAP 
echo "	:lp=${PORT}$ER" >> $NEWCAP 
if [ "$INTERFACE" = "serial" ]; then
	echo "	:br#${BAUD}$ER" >> $NEWCAP 
	echo "	:ms=ixon,-imaxbel,-ixany,-ixoff,-crtscts$ER" >> $NEWCAP 
fi
	echo "	:sd=$SPOOLDIR$ER" >> $NEWCAP 
	echo "	:lf=$SPOOLDIR/log$ER" >> $NEWCAP 
	
	# acct meccanism


	if [ ${SPOOLER_SYSTEM} = "lprng" ]
	then
	echo "	:af=$SPOOLDIR/acct-read=${printer_file}$ER" >> $NEWCAP 
	echo "	:bkf$ER" >> $NEWCAP 
	else
	echo "	:af=$SPOOLDIR/acct-${ENCODED}$ER" >> $NEWCAP 
	fi

	echo "	:if=/usr/local/bin/unifilter$ER" >> $NEWCAP 
	echo "	:mx#0$ER" >> $NEWCAP 
	echo "	:sh:" >> $NEWCAP 



#  ... another printer
done

echo
echo "GLOBAL SETTINGS"
echo
sleep 2


echo  "... setting /dev/dsp e /dev/sequencer +rw permission :-( ..."

chmod go+rw /dev/dsp 2>/dev/null
chmod go+rw /dev/sequencer 2>/dev/null


echo "... setting ${MODEM} +rw permission :-( ..."

ln -s ${MODEM} /dev/modem 2> /dev/null

if [ -z `writable /dev/modem 2>/dev/null` ]
then
chmod go+rw /dev/modem 2>/dev/null
fi


# for  tgz packages

	echo  "... copying script & binary ..."
	sleep 1
	chmod +x unifilter pathfinder
	cp -p unifilter /usr/local/bin
	cp -p pathfinder /usr/local/bin

	echo  "... copying lprMagic.1 man pages ..."
	sleep 1
	cp lprMagic.1 /usr/man/man1 2>/dev/null
	
cat <<END

Searching for mpage package ... 
[mpage print  multiple  pages  per  sheet and convert txt->ps. 
This package is required for lprMagic]

END

                                                                                     
mpage_installed=`which mpage`                                                
                                                                                     
if [ "$mpage_installed" ] ; then 

	req="Found. Do You want (re)install mpage anyway [y]?"
else
	req="Not found. Do You want install mpage [y]?"

fi	

echo -n $req 
read ans

case "Z${ans}Z" in
ZyZ|ZZ)
	install_mpage
	;;
*)
	;;
esac
                                                      

#echo  "... /etc/lprMagic.conf analysis ..."
#sleep 3 

#pathfinder /etc/lprMagic.conf -l 2>&1 

echo ""
echo "Installation of lprMagic Filter done."

