#! /bin/bash
# by M. Andreoli (1997)

#set -x
PATH=/bin:/usr/bin:/usr/sbin:/sbin:/usr/local/bin:

# config.sh - setup lprMagic Universal Filter 
# 
#
VERSION=`cat version.h | awk '{print $3}' | tr -d \"`
SEP=";"
OLDCAP=/etc/printcap.old
SPOOL=/var/spool

sleep 1
clear


# Local function

prompt()
{

var=$1
default=$2
shift 2

message="$*"

if [ ! -z "${message}" ] 
then
	message="${message} "
else
	message="Enter ${var} "
fi

echo
echo -n "${message}[$default]> "
read answer
echo

if [ "${answer}" ]
then
	eval export ${var}=\"${answer}\"
else
	eval export ${var}=${default}
fi
}

# gs(1) avalaible device list

query_gs()
{
if [ `which gs` ]
then
	gs -v
	gs -h > /tmp/gs_device
else
	echo "gs not installed\!" >/tmp/gs_device
	exit
fi

ed /tmp/gs_device <<END  2>&1 >/dev/null
/Available device/
1,. d
/Search path/
.,$ d
wq
END
}

get_global()
{


echo "Linux Systems Serial Ports:"
echo 
echo "     /dev/ttyS0  4     64      0x278      (serial device COM1) [mouse]"
echo "     /dev/ttyS1  4     65      0x278      (serial device COM2) [modem]"
echo "     /dev/ttyS2  4     66      0x278      (serial device COM3) [printer]"
echo ""

prompt MODEM /dev/ttyS1 "What's the device name for your FAX/MODEM interface ?" 


# The default printer?

DEFAULT_PRINTER=

for p in `ls printer.*`
do
. ${p}

if [ "${DEFAULT}" = yes ]
then
	DEFAULT_PRINTER=${p}
	continue
	
fi
done


cat > global.config << END
VERSION=${VERSION}
SPOOLER_SYSTEM=${SPOOLER_SYSTEM}
DEFAULT_PRINTER=${DEFAULT_PRINTER}
MODEM=${MODEM}
END



clear
echo "List of configured printer"
echo "Please!!, check if correct or make config again ..."
echo "-----------------------------------------------------"
echo ""
 /bin/ls -F printer.*
echo
cat global.config
echo "-----------------------------------------------------"


rm -f /tmp/gs_device


echo ""
echo "Configuration of lprMagic Filter saved in global.config "
}


get_parameters()
{
device_setting=` echo "${ENCODED}"| sed "s/;.*//"`
eval ${device_setting}
DEVICE=${device}

PRINTER=${DEVICE}

case ${DEVICE} in
smb)			PORT=/dev/null; INTERFACE=parallel;;
null)			PORT=/dev/null; INTERFACE=parallel;;
gs_*)			PRINTER=`echo ${DEVICE}| sed "s/^gs_//g"`;;
esac


case $PRINTER in
        PS_300dpi)                     	RES=300x300 ;;
        PS_400dpi)     	                RES=400x400 ;;
        PS_600dpi)             	        RES=600x600 ;;
        PS_800dpi)                     	RES=800x800 ;;
        cdesk*|cdj*|desk*|djet*)	RES=300x300 ;;
        laserjet|ljet[23]*)            	RES=300x300 ;;
        ljet4)                         	RES=600x600 ;;
        paintjet|pj*)                  	RES=300x300 ;;
        necp6|bj200)                   	RES=360x360 ;;

        *)                              # when printer is not known exactly
                                        # we assume a default of 300x300
                                        #
                                        GS_RESOL=300x300 ;;
esac

# Resolution

RESOLUTION=

case $DEVICE in
gs_*)
prompt RESOLUTION  ${RES:-"300x300"} "What resolution do you use?" 
;;
PS_*)  RESOLUTION=${RES}
;;
esac

[ ${RESOLUTION} ] && ENCODED="${ENCODED};resolution=${RESOLUTION}"

PAPERSIZE=

case $DEVICE in
gs_*| PS_*)
prompt PAPERSIZE a4 "What paperformat do you use (i.e.: a3, a4, letter,...)?" 
;;
esac

[ ${PAPERSIZE} ] && ENCODED="${ENCODED};papersize=${PAPERSIZE}"

# Interface

if [  "${PORT}" != "/dev/null" ]
then

prompt inter_ans p "This printer have a (s)erial or a (p)arallel interface?" 

case $inter_answer in
	s|S|y|Y)	INTERFACE=serial	;;
	p|P|n|N)	INTERFACE=parallel	;;
	*)		echo "*** I guess you have a parallel printer ***"
			INTERFACE=parallel	;;
esac

echo 
echo "For Linux Sytems (Unix on PC's):"
echo "     Device Name Major Minor   I/O address!"
case $INTERFACE in
    parallel)
	echo "     /dev/null   			(test     device)"
	echo "     /dev/lp0    6     0       0x3bc	(parallel device)"
	echo "     /dev/lp1    6     1       0x378	(parallel device)"
	echo "     /dev/lp2    6     2       0x278	(parallel device)"
	echo ""
	echo "type in the full path name, i.e.: /dev/lp0"
	ex=/dev/lp1
	;;
    serial)
	echo "     /dev/null   			(test     device)"
	echo "     /dev/ttyS0  4     64      0x278	(serial device COM1) [mouse]"
	echo "     /dev/ttyS1  4     65      0x278	(serial device COM2) [modem]"
	echo "     /dev/ttyS2  4     66      0x278	(serial device COM3) [printer]"
	echo ""
	echo "type in the full path name, i.e.: /dev/ttyS2"
	ex=/dev/ttyS1
	;;
esac


prompt PORT ${ex} "What's the PORT name for your $INTERFACE printer interface ?"

fi


# Baud rate

if [ "$INTERFACE" = "serial" ]; then
    prompt BAUD 9600 "Enter the baudrate for your serial printer"
fi

}

# Main

echo "------------------------------------------------------------------------"
echo "-     Configure: setup lprMagic                          by M. Andreoli-"
echo "------------------------------------------------------------------------"
echo "									     "
echo " This script automatically sets up a serial or parallel printer.       "
echo " Spool directories in /var/spool will be automatically created        "
echo " as needed "
echo "									    "
echo "------------------------------------------------------------------------"


#rm -f global.config

echo 
echo "Found this printer configuration file in this directory:"
echo
echo
printer_list=`/bin/ls -F printer.* 2>/dev/null`


if [ "${printer_list}" ]
then
	echo ${printer_list}
else
	echo "none"
fi
echo

prompt REMOVE_PRINTER n "Do you want remove this printers?(y/n)"

[ ${REMOVE_PRINTER} = "y" ] && (echo "Removed."; rm -f printer.*)


prompt SPOOL /var/spool "Enter spool dir on your system"

prompt DISTINCT n "Do you want DISTINCT spool dir for any printer? (y/n)"

echo
case ${DISTINCT} in
y|Y)
	echo "Any spool dir has this form: ${SPOOL}/printer_label"
	;;
n|N)
	echo "The unique spool dir is: ${SPOOL}/printer"
	;;
esac
 

echo
echo ""
echo "You have a "
echo ""
echo "  1 - lpr Berkeley spool system"
echo "  2 - lprng [EXPERIMENTAL]"

prompt ss_ans 1 "what? (1/2) "

case ${ss_ans} in
1)	SPOOLER_SYSTEM=BSD;;
2)	SPOOLER_SYSTEM=lprng;;
esac


cont=yes

sleep 2

while [ ${cont} ]
do
clear

echo
echo "Current printer list:"  
echo "---------------------"
echo

list=`find printer.* 2>/dev/null`

if [ "${list}" ]; then
	echo $list
else
	echo "none"
fi

echo ""
echo "Printer type "
echo ""
echo "	1 - for a Postscript printer"
echo "	2 - for a not-Postscript printer, via gs-emulation"
echo "	3 - for a SAMBA printer"
echo "	4 - for expert user"
echo "	"
echo "	q - quit, finish."
echo

prompt TYPE 2 "Which printer do you want?" 


case $TYPE in
    1)	# PS printer
	echo "Very fine, you have a real PS printer..."
	echo "Please enter a devise specification in the form PS_xyz:"
	echo ""
	echo "i.e.:  PS_300dpi "
	echo ""
	prompt DEVICE PS_300dpi  
	
	ENCODED="device=${DEVICE}"
	get_parameters
	
	;;
    2)	# other, ps emul
	
	echo "Quering gs for driver listing ..."
	sleep 2
	query_gs
	echo "Select one of the following gs(1) output driver ..."
	echo ""
	cat /tmp/gs_device

	prompt GS_DEVICE laserjet  
	DEVICE=gs_${GS_DEVICE}
	ENCODED="device=${DEVICE}"
	get_parameters
	;;

  3)	# samba printer

	echo "Enter host e LAN printer name," 
	echo "and user/password authorization (if any)"
	echo "for ths LAN printer"
	echo
	echo "The SAMBA service is \\host\printer."
	
	prompt SMB_HOST localhost "host?"
	prompt SMB_PRINTER "" "LAN printer?"
	prompt SMB_USER "" "user?" 
	prompt SMB_PASSWORD "" "password?"

	DEVICE=smb

ENCODED="\
device=${DEVICE}\
;host=${SMB_HOST}\
;printer=${SMB_PRINTER}\
;user=${SMB_USER}\
;password=${SMB_PASSWORD}\
"
	
	get_parameters
	;;
  4 )  # expert 
	sleep 2
	clear
	echo ":-))"
	echo "You have to specify the complete encoded"
	echo "string for this device, like:"
	echo
	echo "  	param=value;param=value;param=value .... "
	echo 
	echo "See man pages for update list of build-in parameters,"
        echo "or add some new switch yourself, if you want."
        echo "Note: device= is mandatory."
        echo ""
        echo "Typical examples:"
        echo
        echo "> device=raw"
        echo "> device=audio"
        echo "> device=ftp; user=anonymous; host=flashnet.it; at=midnight"
        echo "> device=gs_laserjet;papersize=a4;resolution=300x300"
        echo "> device=gs_deskjet;papersize=letter;resolution=300x300;sheet=4"
        echo "> device=hp-pcl;output=>/tmp/hppcl.out"
        echo "> device=mail;from=a@b;to=x@y"
        echo "> device=fax;from=X and  Y;faxid=Ananke;to=x@y"
        echo
	echo
	ok=n
	while [ ${ok} != "y" ]
	do
        prompt ENCODED '' "Enter ENCODED string:" 
	echo "Your ENCODED string is: ${ENCODED}"
	prompt ok n "Is ok?(y/n)"
	done

	get_parameters
        ;;

  q )  # quit
	get_global
	exit
	;;
esac

# 


# Printcap label

echo

echo "For this printer, enter a printcap LABEL, "
echo "if You want use it via lpr -P specification"

prompt LABEL ${PRINTER} "Enter a label or press ENTER"

case ${DISTINCT} in
y|Y)
       	SPOOLDIR=${SPOOL}/${LABEL} 
        ;;
n|N)
       	SPOOLDIR=${SPOOL}/printer 
        ;;
esac


# Default printer ?

echo

prompt default_ans n "This printer is the DEFAULT printer (y/n)?" 

case ${default_ans} in
        y|Y)      DEFAULT=yes
	;;

        *)        DEFAULT=no;;
esac



# Save in printer.$LABEL the user config

cat > printer.${LABEL} <<END
LABEL=${LABEL}
ENCODED="${ENCODED}"
DEFAULT=${DEFAULT}
SPOOLDIR=${SPOOLDIR}
INTERFACE=${INTERFACE}
PORT=${PORT}
BAUD=${BAUD}
END

sleep 1
clear


# printer summary
echo "-------------------------"
echo "Summary for this printer:"
echo "-------------------------"

cat printer.${LABEL}

echo


# help


echo
echo "Well. You can use this device by typing something like"
echo
echo "  	lpr -C\"${ENCODED}\" file_name"
echo "  or "
echo "  	lpr -P${LABEL} file_name"
echo



prompt another_ans y "Do you want another printer? (y/n)"

case $another_ans in
        s|S|y|Y)        cont=yes ;;
        *)       	cont= ;;
esac

done


get_global
