indexing

	description: "A command option, representable as a range of numeric values"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"

class SET_OPTION_RANGE
   
inherit
	
	SET_OPTION
		rename 
			value as lower_value,
			set_value as set_lower_value
		redefine
			is_match_for, display_indented, out
		end
	
feature {ANY} -- Status report
	
	upper_value: STRING
			-- The upper value for the range.  
			--| The lower value is inherited from SET_OPTION.
	
	is_match_for (option: STRING): BOOLEAN is
			-- Is the numeric form of `option' within range for this option?
		local
			real_option: REAL
			in_range: BOOLEAN
		do
			-- get the real value of the option
			if option.is_integer then
				real_option := option.to_integer
			else
				real_option := option.to_real
			end
			-- is the option within the range?
			in_range := real_option >= real_lower and real_option <= real_upper
			-- is it the correct type
			if lower_value.is_integer then
				Result := in_range and option.is_integer
			else
				Result := in_range and option.is_real
			end
		end -- is_match_for
	
feature {NONE} -- Implementation
	
	real_lower: REAL is
			-- Temporary real values for comparison
		do
			-- check the type of the value
			if lower_value.is_integer then
				Result := lower_value.to_integer
			else
				Result := lower_value.to_real
			end
		end -- real_lower
	
	real_upper: REAL is
			-- Temporary real values for comparison
		do
			-- check the type of the value
			if upper_value.is_integer then
				Result := upper_value.to_integer
			else
				Result := upper_value.to_real
			end
		end -- real_upper
	
feature {ANY} -- Status setting
	
	set_upper_value (new_value: STRING) is
			-- Set the range upper value to `new_value'.  Will clone new_value.
		require
			valid_value: new_value /= Void
		do
			upper_value := clone (new_value)
		end -- set_upper_value
	
	set_lower_upper (new_lower, new_upper: STRING) is
			-- Set the upper and lower values
		require
			valid_lower: new_lower /= Void
			valid_upper: new_upper /= Void
		do
			lower_value := clone (new_lower)		 
			upper_value := clone (new_upper)
		end -- set_lower_upper
	
feature {DISPLAYABLE} -- Display
	
	display_indented (file: IO_MEDIUM; level: INTEGER) is
			-- Output textual representation indented `level' spaces on `file'.
		do
			display_indent (file, level)
			file.putstring (lower_value)
			file.putstring ("-")
			file.putstring (upper_value)
		end -- display_indented 
	
feature {ANY} -- Display 
	
	out: STRING is
			-- String representation of this option
		do
			Result := lower_value
			Result.append ("-")
			Result.append (upper_value)
		end -- out
	
invariant
	
	-- integer_lower: lower_value.is_integer
	-- integer_upper: upper_value.is_integer
	
end -- class SET_OPTION_RANGE

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

