indexing
	
	description: "An option for a printer command, represented by a string value"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"
	
class SET_OPTION
	
inherit
	
	DISPLAYABLE
		redefine
			out
		end
	
	CHARACTER_ROUTINES
		export
			{NONE} all
		undefine
			out
		end
	
feature {ANY} -- Status report
	
	value: STRING
			-- The value of this option
	
	is_match_for (option: STRING): BOOLEAN is
			-- Is `option' a match for this set option?
		require
			valid_option: option /= Void
		do
			Result := option.is_equal (value)
		end -- is_match_for
	
feature {ANY} -- Status setting
	
	set_value (new_value: STRING) is
			-- Set the option value to `new_value'.  Will clone new_value.
		require
			valid_value: new_value /= Void
		do
			value := clone (new_value)
		end -- set_value
	
feature {DISPLAYABLE} -- Display
	
	display_indented (file: IO_MEDIUM; level: INTEGER) is
			-- Output textual representation indented `level' spaces on `file'.
		do
			display_indent (file, level)
			file.putstring (printable_string (value))
		end -- display_indented 
	
feature {ANY} -- Display 
	
	out: STRING is
			-- String representation of this option
		do
			Result := printable_string (value)
		end -- out
	
end -- class SET_OPTION

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
