indexing
	
	description: "Printer language setting command"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"
	
class PRINTER_LANGUAGE
	
inherit
	
	DISPLAYABLE
	
	CHARACTER_ROUTINES
		export 
			{NONE} all
		end
	
feature {ANY} -- Status report
	
	command: STRING
			-- The printer command string used to set the printer to this
			-- print language.
	
	leave_command: STRING
			-- The printer leave command for this printer language.  eg Ctrl-D
			-- for Postscript.
	
	magic_offset: INTEGER
			-- The offset in the print file to start the search for
			-- `magic_string' to determine whether a file contains this printer language.
	
	magic_string: STRING
			-- The string to search for starting at `offset' to determine the
			-- language of a print file.
	
	is_printer_language (file: IO_MEDIUM): BOOLEAN is
			-- Does `file' contain data conforming to this printer language.
			-- Determined searching for `magic_string' starting at `magic_offset'.
		require
			valid_file: file /= Void
			file_readable: file.is_readable
		do
			Result := True
		end -- is_printer_language
	
feature {ANY} -- Status setting
	
	set_command (new_command: STRING) is
			-- Set the printer command to `new_command'.  Will clone the
			-- string.
		require
			valid_command: new_command /= Void
		do
			command := clone (new_command)
		end -- set_command
	
	set_leave_command (new_leave_command: STRING) is
			-- Set the printer leave_command to `new_leave_command'.  Will clone the
			-- string.
		require
			valid_leave_command: new_leave_command /= Void
		do
			leave_command := clone (new_leave_command)
		end -- set_leave_command
	
	set_magic_offset (new_offset: INTEGER) is
			-- Set the magic string search offset to `new_offset'.
		require
			valid_offset: new_offset >= 0
		do
			magic_offset := new_offset
		end -- set_magic_offset
	
	set_magic_string (new_magic_string: STRING) is
			-- Set the magic search string to `new_magic_string'.  Will
			-- clone the string.
		require
			valid_string: new_magic_string /= Void
		do
			magic_string := clone (new_magic_string)
		end -- set_magic_string
	
feature {DISPLAYABLE} -- Display
	
	display_indented (file: IO_MEDIUM; level: INTEGER) is
			-- Output textual representation indented `level' spaces on `file'.
		do
			display_indent (file, level)
			file.putstring ("command = `")
			file.putstring (printable_string (command))
			file.putstring ("' leave_command = `")
			file.putstring (printable_string (leave_command))
			file.putstring ("' offset = ")
			file.put_integer (magic_offset)
			file.putstring (" magic = `")
			file.putstring (printable_string (magic_string))
			file.putstring ("'%N")
		end -- display_indented
	
end -- class PRINTER_LANGUAGE

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
