indexing

	description: "Temporary semantic information for hpmodeset config parsing"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:45"
	revision: "1.1.1.1"

class HP_CONFIG_SEMANTIC_INFORMATION
	
creation
	
	make
	
feature {NONE} -- Initialisation
	
	make is
		do
			!! configuration.make
			!! last_option_list.make
		end; -- make
	
feature {ANY} -- Check
	
	check_clear: BOOLEAN is
			-- Check that all semantic information is clear.  This is
			-- usually performed after complete semantic application to
			-- ensure that no information has been forgotten or has not been
			-- cleared properly.
		do
			Result := last_alpha = Void and last_switch = Void and last_numeric = Void 
			and last_interval_lower = Void and last_interval_upper = Void and last_string = Void
			and last_real = Void and last_magic_string = Void
			and last_set_option = Void and last_default_option = Void and last_option_list = Void
			and last_variable_syntax = Void and last_language = Void and last_language_name = Void
			and last_language_leave_command = Void
		end -- check_clear
	
feature {ANY} -- Semantics
	
	configuration: PRINTER_CONFIGURATION
			-- The configuration tables to be built from the parsed config file.
	
feature {ANY} -- Terminal semantics
	
	last_alpha: STRING
			-- The last alpha type value.
	
	set_last_alpha (alpha: STRING) is
			-- Set the last alpha to `alpha'
		do
			last_alpha := clone (alpha)
		end -- set_last_alpha
	
	last_switch: STRING
			-- The last switch type value (without the leading hyphen).
	
	set_last_switch (switch: STRING) is
			-- Set the last switch to `switch'
		do
			last_switch := clone (switch)
		end -- set_last_switch
	
	last_numeric: STRING
			-- The last numeric type value (in string form).
	
	set_last_numeric (numeric: STRING) is
			-- Set the last numeric to `numeric'
		do
			last_numeric := clone (numeric)
		end -- set_last_numeric
	
	last_real: STRING
			-- The last real type value (in string form).
	
	set_last_real (real: STRING) is
			-- Set the last real to `real'
		do
			last_real := clone (real)
		end -- set_last_real
	
	last_interval_upper: STRING
			-- The last interval upper value value (in string form).
	
	set_last_interval_upper (interval: STRING) is
			-- Set the last interval_upper to `interval'
		do
			last_interval_upper := clone (interval)
		end -- set_last_interval_upper
	
	last_interval_lower: STRING
			-- The last interval lower value value (in string form).
	
	set_last_interval_lower (interval: STRING) is
			-- Set the last interval_lower to `interval'
		do
			last_interval_lower := clone (interval)
		end -- set_last_interval_lower
	
	last_string: STRING
			-- The last string type value (without the leading and
			-- trailing quotes).
	
	set_last_string (string: STRING) is
			-- Set the last string to `string'
		do
			last_string := clone (string)
		end -- set_last_string
	
feature {ANY} -- Indirect terminals
	
	last_magic_string: STRING
			-- The magic string value for printer languages
	
	set_last_magic_string (string: STRING) is
			-- Set the last magic string to `string'.  Will clone string.
		do
			last_magic_string := clone (string)
		end -- set_last_magic_string
	
	last_language_command: STRING
			-- The printer language command
	
	set_last_language_command (string: STRING) is
			-- Set the last magic string to `string'.  Will clone string.
		do
			last_language_command := clone (string)
		end -- set_last_language_command
	
feature {ANY} -- Variables
	
	last_set_option: SET_OPTION
			-- The last printer setting option value
	
	set_last_set_option (option: SET_OPTION) is
			-- Set the last set option to `option'.  Will clone option.
		do
			last_set_option := option
		end -- set_last_set_option
	
	last_default_option: SET_OPTION
			-- The last default option 
	
	set_last_default_option (option: SET_OPTION) is
			-- Set the last default option to `option'.  
		do
			last_default_option := option
		end -- set_last_default_option
	
	last_option_list: LINKED_LIST [SET_OPTION]
			-- List of options 
	
	set_last_option_list (l: LINKED_LIST [SET_OPTION]) is
			-- Set the list to l
		do
			last_option_list := l
		end -- set_last_option_list
	
	last_variable_syntax: STRING
			-- The last variable syntax for a printer variable
	
	set_last_variable_syntax (string: STRING) is
			-- Set the last variable syntax to `string'.  Will clone string.
		do
			last_variable_syntax := clone (string)
		end -- set_last_variable_syntax
	
feature {ANY} -- Languages
	
	last_language: PRINTER_LANGUAGE
	
	set_last_language (new_language: PRINTER_LANGUAGE) is
		do
			last_language := new_language
		end -- set_last_language
	
	last_language_name: STRING
	
	set_last_language_name (new_name: STRING) is
		do
			last_language_name := new_name
		end -- set_last_language_name
	
	last_language_leave_command: STRING
	
	set_last_language_leave_command (new_name: STRING) is
		do
			last_language_leave_command := new_name
		end -- set_last_language_leave_command
	
end -- class HP_CONFIG_SEMANTIC_INFORMATION

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
