indexing

	description: "Lexical scanner for hpmodeset config files"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:44"
	revision: "1.1.1.1"

class HP_CONFIG_SCAN

inherit

	HP_CONFIG_LEXICAL
	ARGUMENTS
		undefine
			copy, consistent, is_equal, setup
		end

creation

	make

feature 

	make is
			-- Create a lexical analyser for hp config if none,
			-- then use it to analyze the file of name
			-- `file_name'.
		local
			file_name: STRING;
		do
			if argument_count /= 1 then
				file_name := "config";
			else
				file_name := argument (1);
			end;
			io.putstring ("%NBuilding analyzer.");
			metalex_make;
			ready_analyzer;
			make_analyzer;
			io.putstring ("%NScanning file `");
			io.putstring (file_name);
			io.putstring ("'.");
			analyze (file_name);
		end -- make

feature -- Status setting

	analyze (input_file_name: STRING) is
			-- Perform lexical analysis on file
			-- of name `input_file_name'.
		do
			from
				analyzer.set_file (input_file_name);
				begin_analysis
			until
				analyzer.end_of_text
			loop
				analyzer.get_any_token;
				do_a_token (analyzer.last_token)
			end;
			end_analysis
		end; 

feature -- Output

	end_analysis is
			-- Terminate lexical analysis.
			-- This default version of the procedure
			-- does nothing.
			-- It may be redefined in descendants
			-- for specific processing.
		do
			io.putstring ("%NAnalysis complete.")
		end;

	begin_analysis is
			-- Initialize lexical analysis.
			-- This default version of the procedure
			-- simply prints header information.
			-- It may be redefined in descendants
			-- for specific processing.
		do
				io.new_line;
				io.putstring ("--------------- LEXICAL ANALYSIS OF HPSETMODE CONFIG FILES: ----%N");
				io.new_line;
		end;

	do_a_token (read_token: TOKEN) is
			-- Handle `read_token'.
			-- This default version of the procedure
			-- simply prints information on `read_token'.
			-- It may be redefined in descendants
			-- for specific processing.
		require
			argument_not_void: read_token /= Void
		local
			type, int: INTEGER
		do
			type := read_token.type;
			if read_token.keyword_code /= -1 then
				io.putstring ("%NKeyword:  ");
				io.putstring (read_token.string_value);
				io.putstring (" Code: ");
				io.putint (read_token.keyword_code);
			elseif type /= 0 then
				io.putstring ("%NToken type ");
				io.putint (read_token.type);
				io.putstring (": ");
				io.putstring (read_token.string_value);
			end
		end 

end -- class HP_CONFIG_SCAN

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
