indexing

	description: "Lexical analyser for hpmodeset config tokens"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:44"
	revision: "1.1.1.1"

class HP_CONFIG_LEXICAL 

inherit
	
	L_INTERFACE
		redefine
			build
		end
	
	HP_CONFIG_LEX_CONSTANTS
		undefine
			consistent, copy, is_equal, setup
		end
	
feature {NONE}
	
	build (doc: INPUT) is
			-- Create lexical analyzer and set `doc'
			-- to be the input document.
		do
			metalex_make
			ready_analyzer
			make_analyzer
			doc.set_lexical (analyzer)
		end -- build
	
	ready_analyzer is
			-- Create lexical analyzer for the Polynomial language.
			--| was obtain_analyzer
		do
			ignore_case;
			keywords_ignore_case;
			build_expressions;
			build_tools;
			build_keywords;
		end; -- ready_analyzer
	
	obtain_analyzer is
			--| do nothing (not called because of redefinition of build which
			--| calls setup_analyser)
		do
		end -- obtain_analyzer
	
	build_expressions is
			-- Define regular expressions
			-- for the HP modeset configuration language
		do
			put_expression ("(%"#%" *($P | '%%' | '%T') %"\n%") *(*(' ' | '%T') *(%"#%" *($P | '%%' | '%T') %"\n%"))", Comment_type, "Comment_type")
			put_expression ("~('a'..'z') *(~('a'..'z') | '_' | ('0'..'9'))", Alpha_type, "Alpha_type")
			put_expression ("$N", Numeric_type, "Numeric_type")
			put_expression ("+('0'..'9') '.' *('0'..'9')", Real_type, "Real_type")
			put_expression ("'-' ('a'..'z') *(~('a'..'z') | '_' | ('0'..'9'))", 
					Switch_type, "Switch_type")
			put_expression ("($N | (+('0'..'9') '.' *('0'..'9'))) '-' ($N | (+('0'..'9') '.' *('0'..'9')))", Interval_type, "Interval_type")
			put_expression ("'%"' *($. - '%"') '%"'", String_type, "String_type") 
		end; -- build_expressions
	
	build_tools is
			-- Build special keywords.
		local
			first_tool, last_tool, the_special_tool: INTEGER
		do
			set_word (";")
			first_tool := last_created_tool
			set_word (",")
			last_tool := last_created_tool
			union (first_tool,last_tool)
			the_special_tool := last_created_tool
			select_tool (the_special_tool)
			associate (the_special_tool, Special)
		end; -- build_tools
	
	build_keywords is
			-- Define keywords (special symbols) for language.
		do
			put_keyword (";", Special)
			put_keyword (",", Special)
			put_keyword ("Section", Alpha_type)
			put_keyword ("EndSection", Alpha_type)
			put_keyword ("globals", Alpha_type)
			put_keyword ("variables", Alpha_type)
			put_keyword ("languages", Alpha_type)
		end -- build_keywords
	
end -- class HP_CONFIG_LEXICAL

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
