indexing

	description: "Syntax for construct Global_list"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:44"
	revision: "1.1.1.1"
	
class S_GLOBAL_LIST inherit

	REPETITION
		redefine
			parse_body,
			has_separator
		end;
	
feature -- Syntax
	
	production: LINKED_LIST [CONSTRUCT] is
			-- Production for:
			-- Global_list is  Comment 
		local
			global_optionals: GLOBAL_OPTIONALS 
		once
			debug ("construct_building") io.new_line; print_name; end;
			!! Result.make;
			Result.forth;
			!! global_optionals.make; put(global_optionals); 
		end; -- production
	
	has_separator: BOOLEAN is
		do
			Result := false
		end; -- has_separator
	
	separator: STRING is ";";
	
	parse_body (level: INTEGER) is
			-- Attempt to find a sequence of constructs with separators
			-- starting at current position. Set committed
			-- at first separator if `commit_on_separator' is set.
		local
			child_found, first_child_found: BOOLEAN;
			separator_found, wrong: BOOLEAN
		do
			from
				child_found := parse_one (level + 1)
				first_child_found := child_found
			until
				not child_found 
			loop
				separator_found := false;
				child_found := false;
				if has_separator then
					separator_found := document.token.is_keyword (separator_code);
					if separator_found then 
						if commit_on_separator then
							committed := true
						end;
						document.get_token 
					end
				end;
				-- to account for repitition constructs that have an optional
				-- separator 	   
				if 	(not has_separator) or 
					optional_separator or separator_found then
					child_found := parse_one (level + 1)
				end
			end;
			-- to account for the optional_separator case.
			wrong := has_separator and (not optional_separator) and separator_found 
				and not child_found;
			complete := first_child_found and not (committed and wrong)
		end; 

feature -- Status report
	
	construct_name: STRING is
		once
			Result := "Global_list";
		end; -- construct_name
	
end -- class S_GLOBAL_LIST

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
