--|-----------------------------------------------------------------
--|   Copyright (c) 1994 Glenn Maughan                            --
--|   <glennm@insect.sd.monash.edu.au                             --
--|   All rights reserved.                                        --
--|-----------------------------------------------------------------

indexing 
	
	description: "Routines to pull appart file_names";
	date: "1996/01/21 23:35:03";
	revision: "1.1.1.1"
	
class FILE_NAME_ROUTINES
	
inherit
	
	CHARACTER_ROUTINES
		export 
			{NONE} all
		end
	
feature {ANY} -- File components
	
	Directory_separator: CHARACTER is '/'
	
	path_part (file_name: STRING): STRING is
			-- The part of the string that makes up the file path.  The
			-- section of `file_name' before the last slash.  A trailing
			-- name part should be included in `file_name'.
		require
			valid_file_name: file_name /= Void
		local
			s: STRING
			last_slash: INTEGER
		do
			s := clone (file_name)
			s.mirror
				last_slash := s.index_of (Directory_separator, 1)
			if last_slash /= 0 then
				s.mirror
					s.head (s.count - last_slash - 1)
				Result := s
			else
				Result := file_name
			end
		end -- path_part
	
	file_name_part (file_name: STRING): STRING is
			-- The part of the string that makes up the file
		require
			valid_file_name: file_name /= Void
		local
			s: STRING
			last_slash: INTEGER
		do
			s := clone (file_name)
			s.mirror
				last_slash := s.index_of (Directory_separator, 1)
			if last_slash /= 0 then
				s.mirror
					s.tail (last_slash - 1)
				Result := s
			else
				Result := file_name
			end
		end -- file_name_part
	
	expand_environment_variables (s: STRING): STRING is
			-- String with any environment variables ($text) expanded to their
			-- current values as defined in the current environment.
		require
			valid_string: s /= Void
		local
			variable_value: STRING
			start: INTEGER
		do
			Result := s
			start := 1
			-- search for the first variable
			from
				find_variable (Result, start)
			until
				not variable_found
			loop
				if variable_found then
					-- get the value of the variable
					debug ("variables")
						io.putstring ("Variable found: ")
						io.putstring (Result.substring (start_of_variable, end_of_variable))
						io.new_line
					end
					variable_value := environment.get (Result.substring 
									   (start_of_variable, end_of_variable))
					if variable_value /= Void then
						debug ("variables")
							io.putstring ("Expanding variable: ")
							io.putstring (variable_value)
							io.new_line
						end
						-- substitute the strings don't forget to include the $ sign
						Result.replace_substring (variable_value, 
									  start_of_variable - 1, end_of_variable)
						-- calculate new start position
						start := (start_of_variable - 1) + variable_value.count
					else
						-- skip unknown variable
						start := end_of_variable + 1
					end
					find_variable (Result, start)
				end
			end
			debug ("variables")
				io.putstring ("Expanded string: ")
				io.putstring (Result)
				io.new_line
			end
		ensure
			string_not_changed: s = old s
		end -- expand_environment_variables
	
feature {NONE} -- Implementation
	
	variable_found: BOOLEAN
			-- Was an environment variable found by the last find_variable operation?
	
	start_of_variable, end_of_variable: INTEGER
			-- The start and end points of the variable found
	
	find_variable (s: STRING; start: INTEGER) is
			-- Search `s' looking for any environment variables.
			-- Environment variables are defined as: $<text> separated by
			-- a non alphabetic character.  If one is found set
			-- variable_found, start_of_variable and end_of_variable
		require
			valid_string: s /= Void
			valid_start_point: start > 0 and then start <= s.count
		local
			dollar_position: INTEGER
			current_position: INTEGER
		do
			variable_found := False
			start_of_variable := 0
			end_of_variable := 0
			-- look for a dollar sign
			dollar_position := s.index_of (Dollar_sign, start)
			-- if found then collect the word
			if dollar_position /= 0 then
				debug ("variables")
					io.putstring ("Found variable at: ")
					io.putint (dollar_position)
					io.new_line
				end
				variable_found := True
				start_of_variable := dollar_position + 1
				end_of_variable := variable_word_end (s, dollar_position + 1)
			end
		end -- find_variable
	
	Dollar_sign: CHARACTER is '$'
	
	variable_word_end (s: STRING; start: INTEGER): INTEGER is
			-- The position at the end of the current word in `s' at position `start'
		require
			valid_string: s /= Void
			valid_start_point: start > 0 and then start <= s.count
		local
			current_position: INTEGER
			found: BOOLEAN
		do
			-- search for the first non alphanumeric character
			from
				found := False
				current_position := start 
			variant
				s.count - current_position
			until
				found or current_position > s.count
			loop
				if not is_alpha_numeric (s.item (current_position)) then
					debug ("variables")
						io.putstring ("Found variable end at: ")
						io.putint (current_position)
						io.new_line
					end
					found := True
				else
					current_position := current_position + 1
				end
			end
			Result := current_position - 1
		end -- variable_word_end
	
	environment: EXECUTION_ENVIRONMENT is
			-- The execution environment
		once
			!! Result
		end -- environment
	
end -- class FILE_NAME_ROUTINES

 