indexing 
	
	description: "Extended implentation of arguments.  Allows more general processing";
	date: "1996/01/21 23:35:03";
	revision: "1.1.1.1"
	
class EXTENDED_ARGUMENTS
	
inherit
	
	ARGUMENTS
		redefine
			option_word_equal,
			coalesced_option_word_value
		end
	
feature {ANY}
	
	coalesced_option_word_value (opt: STRING): STRING is
			-- The value, if any, specified for option `opt' on the command line.
			-- Defined as follows (where `o' is `opt' and X is `option_sign'):
			--   `val' if command line includes an argument of the form `Xoval'
			--		(this may be an empty string if argument is just `Xo').
			--   Void otherwise.
		local
			p : INTEGER
			l : STRING
		do
			p := has_word_option (opt)
			if p /= 0 then
				l := argument_array.item (p)
				Result :=  l.substring (opt.count + 1, l.count)
				Result.remove (1)
			end
		end -- coalesced_option_word_value
	
feature {NONE} -- Argument Implementation
	
	option_word_equal (arg, w : STRING): BOOLEAN is
			-- Is `arg' equal to the word option `w'?  Allows an option
			-- sign by itself and will return true if `w' is empty.
		do
			if internal_option_sign = '%U' then
				Result := arg.is_equal (w)
			elseif arg.count = 1 then
				Result := w.count = 0
			elseif arg.item (1) = option_sign then
				-- check that the argument is big enough
				if (w.count + 1) > arg.count then
					Result := False
				else
					-- check that the substring is equivalent
					Result := arg.substring (2, w.count + 1).is_equal (w)
				end
			end
		end    
	
end -- class EXTENDED_ARGUMENTS

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
