indexing
	description:  "A two way tree that can be displayed indented"
	authors: "Glenn Maughan and Jon Avotins"
	status: "See notice at end of class";
	copyright: "See notice at end of class";
	date: "1996/01/21 23:35:03";
	revision: "1.1.1.1"
	
class DISPLAYABLE_TREE [G -> DISPLAYABLE]
	
inherit
	
	TWO_WAY_TREE [G]
		redefine
			parent
		end
	
	DISPLAYABLE
	
creation
	
	make
	
feature -- Access
	
	parent: like Current
			-- Parent node
	
feature {DISPLAYABLE} -- Display
	
	display_indented (file: IO_MEDIUM; new_level: INTEGER) is
			-- Output textual representation indented `new_level' spaces on `file'.
		do
			-- display the current item
			display_item (file, new_level)
			-- if current is a leaf then we do not need to process any children
			if not is_leaf then
				-- display all subtrees of this subtree at 'new_level + Indent_step'
				from 
					child_start
				until
					child_after
				loop
					child.display_indented (file, new_level + Indent_step)
					child_forth
				end
			end
		end -- display_indented
	
feature {ANY} -- Display
	
	display_item (file: IO_MEDIUM; new_level: INTEGER) is  
			-- Display the current item at cursor
			--| descendants should redefine this routine to display each
			--| individual item in its required form.
		require
			valid_file: file /= Void and then (file.exists and file.is_open_write)
		do
			item.display_indented (file, new_level)
		end -- display_item
	
end -- class DISPLAYABLE_TREE

--|----------------------------------------------------------------
--| ReClass: Class Reengineering Toolset for Object-oriented Systems
--| Copyright (C) 1995, Monash University
--| All rights reserved.
--|
--| Monash University, Caulfield Campus
--| Department of Software Development
--| PO Box 197, Caulfield East
--| Melbourne, Australia 3145
--|
--| COPYRIGHT NOTICE: This code is provided "AS IS" without any
--| warranty and is subject to the terms of the Monash Software
--| Development General Public License contained in the file:
--| "LICENSE" of this distribution. The license is also available
--| from Monash University, Department of Software Development,
--| VIC 3145, Australia.
--|
--| Phone: +61-3-99032787 Fax: +61-3-99032745
--| Email: <reclass@insect.sd.monash.edu.au>
--| WWW: http://insect.sd.monash.edu.au/~reclass
--|----------------------------------------------------------------
 