indexing 
   
	description: "Objects that can be displayed and have the ability to display their % 
	%sub-components indented recursively";
	date: "1996/01/21 23:35:03";
	revision: "1.1.1.1"
	
deferred class DISPLAYABLE
	
feature {ANY} -- Display
	
	display, frozen standard_display (output_file: IO_MEDIUM) is
			-- Output textual representation of Current on `output_file'.  This
			-- routine will display all sub-components (attributes)
			-- recursively indented.
			--| this routine will not open or close `output_file'.
		require
			valid_file: output_file /= Void and then (output_file.exists and output_file.is_open_write)
		do
			display_indented (output_file, Indent_start_level)
		end -- display
	
	Indent_start_level: INTEGER is 0
			-- Level to start the display of this object at in spaces.
	
	Indent_step: INTEGER is 4
			-- The default step of indents for displaying indented.  Add this
			-- number to the current level when displaying an indented component.
	
feature {DISPLAYABLE} -- Display
	
	display_indented (file: IO_MEDIUM; level: INTEGER) is
			-- Output textual representation indented `level' spaces on `file'.
			--| descendants should effect this feature to display the
			--| current object and its subcomponents indented (call
			--| display_indented recursively).
			--| WARNING: Do not change the export status unknowingly.
		require
			valid_file: file /= Void and then (file.exists and file.is_open_write)
			valid_indent: level >= 0
		deferred
		end -- display_indented
	
feature {NONE} -- Implementation
	
	display_indent (file: IO_MEDIUM; level: INTEGER) is
			-- Output `level' spaces on stdout
		require
			valid_file: file /= Void and then (file.exists and file.is_open_write)
			valid_indent: level >= 0
		local
			temp_string: STRING
		do
			-- build an string with level number of spaces
			!! temp_string.make (level)
			temp_string.fill_blank
			-- output the indent
			file.putstring (temp_string)
		end -- display_indent
	
end -- class DISPLAYABLE

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
