indexing 
	
	description: "Useful routines for use with characters.  Classes requiring these features %
	% should inherit from this class";
	date: "1996/01/21 23:35:03";
	log: "See notice at end of class";
	revision: "1.1.1.1"
	
class CHARACTER_ROUTINES
	
inherit
	
	ASCII
	
feature {ANY} -- Comparison
	
	is_numeric (c: CHARACTER): BOOLEAN is
			-- Is `c' a numeric character?
		obsolete "Use CHARACTER.is_digit"
		require
			valid_character: c /= Void
		do
			Result := (c.code >= Zero) and (c.code <= Nine)
		end -- is_numeric
	
	is_alpha (c: CHARACTER): BOOLEAN is
			-- Is `c' an alphabetic character?
		obsolete "Use CHARACTER.is_alpha"
		require
			valid_character: c /= Void 
		do
			Result := ((c.code >= Lower_a) and (c.code <= Lower_z)) 
				or ((c.code >= Upper_a) and (c.code <= Upper_z))
		end -- is_alpha
	
	is_alpha_numeric (c: CHARACTER): BOOLEAN is
			-- Is `c' an alphanumeric character?
		obsolete "Use (CHARACTER.is_digit or CHARACTER.is_alpha)"
		require
			valid_character: c /= Void  
		do
			Result := is_numeric (c) or is_alpha (c)
		end -- is_alpha_numeric
	
feature {ANY} -- Conversion
	
	printable_string (non_printable_string: STRING): STRING is
			-- A string representing `non_printable_string' with all
			-- nonprintable characters converted to a printable representation.
		require
			valid_string: non_printable_string /= Void
		local
			current_index: INTEGER
			new_code_string: STRING
		do
			Result := clone (non_printable_string)
			from 
				current_index := 1
			until
				current_index > Result.count
			loop
				-- check if the current character is a control character
				if is_non_printable_character (Result.item (current_index)) then
					-- replace it with its escaped code
					new_code_string := numeric_code (Result.item (current_index))
					Result.replace_substring (new_code_string, 
								  current_index, current_index) 
					-- skip past the new control character quote 
					current_index := current_index + new_code_string.count
				else
					-- skip to next character
					current_index := current_index + 1
				end
			end   
		ensure
			new_string: non_printable_string /= Result
		end -- string_quoted
	
	is_non_printable_character (c: CHARACTER): BOOLEAN is
			-- Is `c' a recognised control character that has to be excaped
			-- within a string?
		do
			Result := c.code < First_printable or c.code > Last_printable
		end -- is_control_character 
	
	numeric_code (c: CHARACTER): STRING is
			-- Answer the string consisting of the character `c'
			-- numeric code
		require
			is_control_character: is_non_printable_character (c)
		do
			Result := "%%/"
			Result.append (c.code.out)
			Result.append ("/")	 
		end -- numeric_code
	
end -- class CHARACTER_ROUTINES

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
