indexing

	description: "Construct for a printer variable command syntax"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"

class VARIABLE_SYNTAX 

inherit
	
	STRING_TYPE
		redefine
			construct_name,
			action
		end;
	
creation
	
	make
	
feature {CONSTRUCT} -- Semantics
	
	action (level: INTEGER) is
			-- Store the token string value as the last_variable_syntax.  Strip off
			-- the leading and trailing quotes.  Also replace any escaped
			-- characters with their actual character values.
		local
			s: STRING
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("post_action: (storing last_variable_syntax) ")
				print_name
				io.new_line
			end
			-- prune the quotes off the string
			s := token.string_value
			s.remove (1)
			s.remove (s.count)
			-- store the string value in last_variable_syntax
			info.set_last_variable_syntax (unquoted_string (s))
		end -- action
	
feature -- Status Report
	
	construct_name: STRING is
		once
			Result := "Variable_syntax"
		end; -- construct_name
	
end -- class VARIABLE_SYNTAX

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
