indexing

	description: "Construct for a string terminal type"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"

class STRING_TYPE 

inherit
	
	S_STRING_TYPE
		redefine
			action
		end
	
	SEMANTIC_INFORMATION
	
	BASIC_ROUTINES
		export
			{NONE} all
		end
	
creation
	
	make
	
feature {CONSTRUCT} -- Semantics
	
	action (level: INTEGER) is
			-- Store the token string value as the last_string.  Strip off
			-- the leading and trailing quotes.  Also replace any escaped
			-- characters with their actual character values.
		local
			s: STRING
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("post_action: (storing last_string) ")
				print_name
				io.new_line
			end
			-- prune the quotes off the string
			s := token.string_value
			s.remove (1)
			s.remove (s.count)
			-- expand any quoted characters to their real
			-- character equivalent and store the string
			-- value in last_string
			info.set_last_string (unquoted_string (s))
		end -- action
	
feature {NONE} -- Implementation	
	
	Slash_character: CHARACTER is '/'
	Percent_character: CHARACTER is '%%'
	
	unquoted_string (s: STRING): STRING is
			-- Expand any quoted characters in `s' to their actual
			-- character values.  Will 
		require
			valid_string: s /= Void
		local
			index: INTEGER
			quote_position: INTEGER
			end_position: INTEGER
			error: BOOLEAN
		do
			-- copy the string
			Result := clone (s)
			-- iterate across the string removing all
			-- quoted characters (beginning with %) and
			-- replacing with actual character values
			from
				index := 1
			until
				index > Result.count
			loop
				-- find the next quote character (if
				-- it exists)
				quote_position := Result.index_of (Percent_character, index)
				-- check whether one was found
				if quote_position = 0 then
					-- not found, we are done
					index := Result.count + 1
				else
					-- found, find the end of the quoted character part
					end_position := end_of_quote_position (Result, quote_position)
					-- replace the quoted part with the literal
					-- character string
					Result.replace_substring (expand_quote 
								  (Result.substring (quote_position, end_position)),
										     quote_position, end_position)
					-- go to the next character
					index := quote_position + 1
				end
			end
			
		ensure
			new_string: s /= Result
			no_characters_lost: Result.count <= s.count
		end -- unquoted_string
	
	end_of_quote_position (s: STRING; start_position: INTEGER): INTEGER is
			-- The position of the end of the quote part.  One more than `start_position' if
			-- a normal quoted character, or the end of the last slash if a numeric
			-- ASCII code quote part.
		require
			valid_string: s /= Void
			valid_position: start_position > 0
			string_big_enough: s.count > start_position
		do
			-- check the next character
			if s.item (start_position + 1).is_equal (Slash_character) then
				-- we have an ascii code, find the next slash
				Result := s.index_of (Slash_character, start_position + 2)
			else
				Result := start_position + 1
			end
		ensure
			end_position_greater: Result > start_position
			end_position_smaller: Result <= s.count
		end -- end_of_quote_position
	
	expand_quote (quote_string: STRING): STRING is
			-- Expand the `quote_string' into its single character value.
		require
			valid_string: quote_string /= Void
			string_big_enough: quote_string.count >= 2     -- allows "%x"
			string_small_enough: quote_string.count <= 6   -- allows "%/xxx/"
		local
			new_character: CHARACTER
		do
			-- check the second character
			if quote_string.item (2).is_equal (Slash_character) then
				-- we have an ascii code, find the number and convert
				-- get the string between position 3 and one less than count
				!! Result.make (1)
				Result.append_character (charconv (quote_string.substring (3, quote_string.count - 1).to_integer))
			else
				inspect (quote_string.item (2))
				when 'B' then
					Result := "%B"
				when 'F' then
					Result := "%F"
				when 'N' then
					Result := "%N"
				when 'R' then
					Result := "%R"
				when 'T' then
					Result := "%T"
				when 'U' then
					Result := "%U"
				when '%%' then
					Result := "%%"
				else
					Result := ""
				end
			end
		end -- expand_quote
	
end -- class STRING_TYPE

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
